/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui;

import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.components.FileListWidget;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.client.gui.util.PathUtils;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FileSelectionScreen
extends Screen {
    private static final int PANEL_WIDTH = 280;
    private static final int PANEL_HEIGHT = 200;
    private static final int BUTTON_WIDTH = 45;
    private static final int BUTTON_HEIGHT = 16;
    private final ReplacementEditorScreen parent;
    private EditBox searchBox;
    private Button backButton;
    private Button refreshButton;
    private FileListWidget fileList;
    private final List<PathUtils.FileInfo> allFiles;
    private List<PathUtils.FileInfo> filteredFiles;
    private String lastSearchText = "";

    public FileSelectionScreen(ReplacementEditorScreen parent) {
        super((Component)Component.m_237115_((String)"gui.oneenoughitem.file_selection.title"));
        this.parent = parent;
        this.allFiles = new ArrayList<PathUtils.FileInfo>();
        this.filteredFiles = new ArrayList<PathUtils.FileInfo>();
        this.loadJsonFiles();
    }

    private void loadJsonFiles() {
        this.allFiles.clear();
        this.allFiles.addAll(PathUtils.scanAllReplacementFiles());
        this.filteredFiles = new ArrayList<PathUtils.FileInfo>(this.allFiles);
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int panelX = centerX - 140;
        int panelY = centerY - 100;
        this.searchBox = new EditBox(this.f_96547_, panelX, panelY - 25, 180, 18, (Component)Component.m_237115_((String)"gui.oneenoughitem.file_selection.search"));
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"gui.oneenoughitem.file_selection.search.hint"));
        this.m_142416_((GuiEventListener)this.searchBox);
        this.refreshButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.file_selection.refresh"), button -> this.refreshFileList(), panelX + 280 - 95, panelY - 25, 45, 18);
        this.m_142416_((GuiEventListener)this.refreshButton);
        this.backButton = GuiUtils.createButton((Component)Component.m_237115_((String)"gui.oneenoughitem.back"), button -> this.f_96541_.m_91152_((Screen)this.parent), panelX + 280 - 45, panelY - 25, 45, 18);
        this.m_142416_((GuiEventListener)this.backButton);
        this.fileList = new FileListWidget(this.f_96541_, 280, 180, panelY + 5, 28, this::onFileSelected);
        this.fileList.m_93507_(panelX);
        this.m_142416_((GuiEventListener)this.fileList);
        this.updateFileList();
    }

    private void refreshFileList() {
        this.loadJsonFiles();
        this.updateFileList();
    }

    private void updateFileList() {
        String searchText = this.searchBox.m_94155_().toLowerCase();
        this.filteredFiles.clear();
        for (PathUtils.FileInfo file : this.allFiles) {
            if (!searchText.isEmpty() && !file.displayName().toLowerCase().contains(searchText) && !file.fullPath().toLowerCase().contains(searchText) && !file.datapackName().toLowerCase().contains(searchText)) continue;
            this.filteredFiles.add(file);
        }
        this.fileList.setFiles(this.filteredFiles);
    }

    private void onFileSelected(Path filePath, int mode) {
        this.parent.onFileSelected(filePath, mode);
        this.f_96541_.m_91152_((Screen)this.parent);
    }

    public void m_86600_() {
        super.m_86600_();
        this.searchBox.m_94120_();
        String currentSearchText = this.searchBox.m_94155_();
        if (!currentSearchText.equals(this.lastSearchText)) {
            this.updateFileList();
            this.lastSearchText = currentSearchText;
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int panelX = centerX - 140;
        int panelY = centerY - 100;
        GuiUtils.drawPanelBackground(graphics, panelX, panelY, 280, 200);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        graphics.m_280653_(this.f_96547_, this.f_96539_, centerX, panelY - 35, 0xFFFFFF);
        MutableComponent fileCountText = Component.m_237110_((String)"gui.oneenoughitem.file_selection.files_found", (Object[])new Object[]{this.filteredFiles.size()});
        graphics.m_280430_(this.f_96547_, (Component)fileCountText, panelX, panelY + 200 + 5, 0xAAAAAA);
        if (this.allFiles.isEmpty()) {
            MutableComponent helpText = Component.m_237115_((String)"gui.oneenoughitem.file_selection.no_files");
            graphics.m_280653_(this.f_96547_, (Component)helpText, centerX, centerY, 0xFF6666);
        } else {
            MutableComponent helpText = Component.m_237115_((String)"gui.oneenoughitem.file_selection.help");
            graphics.m_280653_(this.f_96547_, (Component)helpText, centerX, panelY + 200 + 15, 0xCCCCCC);
        }
    }

    public boolean m_7043_() {
        return false;
    }
}

