/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.cache;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.gui.cache.BaseCache;
import com.mafuyu404.oneenoughitem.client.gui.util.PathUtils;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;

public abstract class AbstractGlobalReplacementCache
extends BaseCache {
    protected final Map<String, String> replacedData = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> replacedTags = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> resultData = new ConcurrentHashMap<String, String>();
    protected final Map<String, String> resultTags = new ConcurrentHashMap<String, String>();
    protected volatile boolean needsRebuild = false;

    protected AbstractGlobalReplacementCache(String dirName, String domainId) {
        super(dirName, domainId + "_global_replacement_cache.dat", 2);
    }

    protected abstract String domainId();

    @Override
    protected void onInitialized() {
        Oneenoughitem.LOGGER.info("{} global replacement cache initialized (data: {}, tags: {})", (Object)this.domainId(), (Object)this.replacedData.size(), (Object)this.replacedTags.size());
        if (this.needsRebuild) {
            this.needsRebuild = false;
            this.rebuild();
        }
    }

    @Override
    protected void onVersionMismatch(int foundVersion) {
        Oneenoughitem.LOGGER.warn("{} cache version mismatch (found {} != expected {}), scheduling rebuild", (Object)this.domainId(), (Object)foundVersion, (Object)this.cacheVersion);
        this.needsRebuild = true;
    }

    @Override
    protected void onLoadError(IOException e) {
        this.clearAllMaps();
    }

    @Override
    protected void loadData(DataInputStream dis) throws IOException {
        AbstractGlobalReplacementCache.readStringMap(dis, this.replacedData);
        AbstractGlobalReplacementCache.readStringMap(dis, this.replacedTags);
        try {
            AbstractGlobalReplacementCache.readStringMap(dis, this.resultData);
            AbstractGlobalReplacementCache.readStringMap(dis, this.resultTags);
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.info("{} old cache format detected, scheduling rebuild", (Object)this.domainId());
            this.needsRebuild = true;
        }
    }

    @Override
    protected void saveData(DataOutputStream dos) throws IOException {
        AbstractGlobalReplacementCache.writeStringMap(dos, this.replacedData);
        AbstractGlobalReplacementCache.writeStringMap(dos, this.replacedTags);
        AbstractGlobalReplacementCache.writeStringMap(dos, this.resultData);
        AbstractGlobalReplacementCache.writeStringMap(dos, this.resultTags);
    }

    public void addReplacement(Collection<String> matchData, Collection<String> matchTags, String resultDataStr, String resultTagStr, String sourceFile) {
        this.withInitializedWriteLock(() -> {
            String result;
            String string = result = resultDataStr != null ? resultDataStr : resultTagStr;
            if (result == null || result.isEmpty()) {
                Oneenoughitem.LOGGER.warn("Cannot add replacement with null/empty result from file: {}", (Object)sourceFile);
                return;
            }
            AbstractGlobalReplacementCache.processValidStrings(matchData, id -> this.replacedData.put((String)id, result));
            AbstractGlobalReplacementCache.processValidStrings(matchTags, tagId -> this.replacedTags.put((String)tagId, result));
            AbstractGlobalReplacementCache.addToResultMap(resultDataStr, sourceFile, this.resultData);
            AbstractGlobalReplacementCache.addToResultMap(resultTagStr, sourceFile, this.resultTags);
            this.saveToFileAsync();
        });
    }

    public void removeReplacement(Collection<String> matchData, Collection<String> matchTags) {
        this.withInitializedWriteLock(() -> {
            boolean changed = false;
            changed |= this.removeFromReplacementMap(matchData, this.replacedData, "data");
            if (changed |= this.removeFromReplacementMap(matchTags, this.replacedTags, "tag")) {
                this.saveToFileAsync();
            }
        });
    }

    public boolean isDataReplaced(String id) {
        return this.withInitializedReadLock(() -> AbstractGlobalReplacementCache.isValidString(id) && this.replacedData.containsKey(id));
    }

    public boolean isTagReplaced(String tagId) {
        return this.withInitializedReadLock(() -> AbstractGlobalReplacementCache.isValidString(tagId) && this.replacedTags.containsKey(tagId));
    }

    public String getDataReplacement(String id) {
        return this.withInitializedReadLock(() -> AbstractGlobalReplacementCache.isValidString(id) ? this.replacedData.get(id) : null);
    }

    public String getTagReplacement(String tagId) {
        return this.withInitializedReadLock(() -> AbstractGlobalReplacementCache.isValidString(tagId) ? this.replacedTags.get(tagId) : null);
    }

    public boolean isDataUsedAsResult(String id) {
        return this.withInitializedReadLock(() -> AbstractGlobalReplacementCache.isValidString(id) && this.resultData.containsKey(id));
    }

    public boolean isTagUsedAsResult(String tagId) {
        return this.withInitializedReadLock(() -> AbstractGlobalReplacementCache.isValidString(tagId) && this.resultTags.containsKey(tagId));
    }

    public Set<String> getAllReplacedData() {
        return this.withInitializedReadLock(() -> new HashSet<String>(this.replacedData.keySet()));
    }

    public Set<String> getAllReplacedTags() {
        return this.withInitializedReadLock(() -> new HashSet<String>(this.replacedTags.keySet()));
    }

    public void clearAll() {
        this.withInitializedWriteLock(() -> {
            this.clearAllMaps();
            this.saveToFileAsync();
        });
    }

    public void rebuild() {
        this.withWriteLock(() -> {
            int oldDataCount = this.replacedData.size();
            int oldTagCount = this.replacedTags.size();
            this.clearAllMaps();
            this.rebuildFromJsonFiles();
            this.saveToFileAsync();
            Oneenoughitem.LOGGER.info("{} global replacement cache rebuilt: {} -> {} data, {} -> {} tags", (Object)this.domainId(), (Object)oldDataCount, (Object)this.replacedData.size(), (Object)oldTagCount, (Object)this.replacedTags.size());
        });
    }

    protected void rebuildFromJsonFiles() {
        try {
            List<PathUtils.FileInfo> fileInfos = PathUtils.scanAllReplacementFiles(this.domainId());
            fileInfos.forEach(this::processReplacementFile);
            Oneenoughitem.LOGGER.info("{} rebuilt from {} files: data {}, tags {}, resultData {}, resultTags {}", (Object)this.domainId(), (Object)fileInfos.size(), (Object)this.replacedData.size(), (Object)this.replacedTags.size(), (Object)this.resultData.size(), (Object)this.resultTags.size());
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.error("{} failed to rebuild global replacement cache", (Object)this.domainId(), (Object)e);
        }
    }

    protected void processReplacementFile(PathUtils.FileInfo fileInfo) {
        try {
            String content = Files.readString(fileInfo.filePath());
            if (content == null || content.trim().isEmpty()) {
                return;
            }
            JsonElement parsed = (JsonElement)new Gson().fromJson(content, JsonElement.class);
            if (parsed != null && parsed.isJsonArray()) {
                JsonArray jsonArray = parsed.getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    this.processReplacementElement(element, fileInfo);
                }
            }
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("{} failed to read replacement file: {}", (Object)this.domainId(), (Object)fileInfo.filePath(), (Object)e);
        }
    }

    protected void processReplacementElement(JsonElement element, PathUtils.FileInfo fileInfo) {
        try {
            DataResult result = Replacements.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            if (result.result().isPresent()) {
                Replacements replacement = (Replacements)result.result().get();
                String resultString = replacement.result();
                for (String matchItem : replacement.match()) {
                    if (AbstractGlobalReplacementCache.isTag(matchItem)) {
                        this.replacedTags.put(AbstractGlobalReplacementCache.removeTagPrefix(matchItem), resultString);
                        continue;
                    }
                    this.replacedData.put(matchItem, resultString);
                }
                if (AbstractGlobalReplacementCache.isTag(resultString)) {
                    this.resultTags.put(AbstractGlobalReplacementCache.removeTagPrefix(resultString), fileInfo.filePath().toString());
                } else {
                    this.resultData.put(resultString, fileInfo.filePath().toString());
                }
            }
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("{} failed to parse replacement rule in file: {}", (Object)this.domainId(), (Object)fileInfo.filePath(), (Object)e);
        }
    }

    protected static void readStringMap(DataInputStream dis, Map<String, String> map) throws IOException {
        int count = dis.readInt();
        for (int i = 0; i < count; ++i) {
            String key = dis.readUTF();
            String value = dis.readUTF();
            if (!AbstractGlobalReplacementCache.isValidString(key) || !AbstractGlobalReplacementCache.isValidString(value)) continue;
            map.put(key, value);
        }
    }

    protected static void writeStringMap(DataOutputStream dos, Map<String, String> map) throws IOException {
        dos.writeInt(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            dos.writeUTF(entry.getKey());
            dos.writeUTF(entry.getValue());
        }
    }

    protected static boolean isValidString(String str) {
        return str != null && !str.isEmpty();
    }

    protected static boolean isTag(String str) {
        return str != null && str.startsWith("#");
    }

    protected static String removeTagPrefix(String tag) {
        return AbstractGlobalReplacementCache.isTag(tag) ? tag.substring(1) : tag;
    }

    protected static void processValidStrings(Collection<String> strings, Consumer<String> processor) {
        if (strings != null) {
            strings.stream().filter(AbstractGlobalReplacementCache::isValidString).forEach(processor);
        }
    }

    protected static void addToResultMap(String item, String source, Map<String, String> resultMap) {
        if (AbstractGlobalReplacementCache.isValidString(item)) {
            resultMap.put(item, source);
        }
    }

    protected boolean removeFromReplacementMap(Collection<String> items, Map<String, String> replacementMap, String itemType) {
        boolean changed = false;
        if (items != null) {
            for (String item : items) {
                String removedResult;
                if (!AbstractGlobalReplacementCache.isValidString(item) || (removedResult = replacementMap.remove(item)) == null) continue;
                changed = true;
                this.removeFromResultMaps(removedResult);
            }
        }
        return changed;
    }

    protected void removeFromResultMaps(String result) {
        if (AbstractGlobalReplacementCache.isTag(result)) {
            this.resultTags.remove(AbstractGlobalReplacementCache.removeTagPrefix(result));
        } else {
            this.resultData.remove(result);
        }
    }

    protected void clearAllMaps() {
        this.replacedData.clear();
        this.replacedTags.clear();
        this.resultData.clear();
        this.resultTags.clear();
    }

    protected <T> T withInitializedReadLock(Supplier<T> operation) {
        this.initialize();
        return this.withReadLock(operation);
    }

    protected void withInitializedWriteLock(Runnable operation) {
        this.initialize();
        this.withWriteLock(operation);
    }
}

