/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.cache;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.gui.cache.AbstractGlobalReplacementCache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ItemGlobalReplacementCache
extends AbstractGlobalReplacementCache {
    private static final ItemGlobalReplacementCache INSTANCE = new ItemGlobalReplacementCache();
    private final Map<String, String> replacedItems = new ConcurrentHashMap<String, String>();
    private final Map<String, String> replacedTags = new ConcurrentHashMap<String, String>();
    private final Map<String, String> resultItems = new ConcurrentHashMap<String, String>();
    private final Map<String, String> resultTags = new ConcurrentHashMap<String, String>();
    private volatile boolean needsRebuild = false;

    private ItemGlobalReplacementCache() {
        super("oei", "oei");
    }

    @Override
    protected String domainId() {
        return "oei";
    }

    public static AbstractGlobalReplacementCache get() {
        return INSTANCE;
    }

    @Override
    protected void onInitialized() {
        Oneenoughitem.LOGGER.info("Global replacement cache initialized with {} items and {} tags", (Object)this.replacedItems.size(), (Object)this.replacedTags.size());
        if (this.needsRebuild) {
            Oneenoughitem.LOGGER.warn("Global replacement cache scheduled rebuild due to version mismatch or old format; rebuilding now");
            this.needsRebuild = false;
            this.rebuild();
        }
    }

    @Override
    protected void onVersionMismatch(int foundVersion) {
        Oneenoughitem.LOGGER.warn("Global replacement cache version mismatch (found {} != expected {}), will rebuild after initialization", (Object)foundVersion, (Object)this.cacheVersion);
        this.needsRebuild = true;
    }

    @Override
    protected void onLoadError(IOException e) {
        this.clearAllMaps();
    }

    @Override
    protected void loadData(DataInputStream dis) throws IOException {
        ItemGlobalReplacementCache.readStringMap(dis, this.replacedItems);
        ItemGlobalReplacementCache.readStringMap(dis, this.replacedTags);
        try {
            ItemGlobalReplacementCache.readStringMap(dis, this.resultItems);
            ItemGlobalReplacementCache.readStringMap(dis, this.resultTags);
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.info("Old cache format detected, scheduling rebuild to include result tracking");
            this.needsRebuild = true;
        }
    }

    @Override
    protected void saveData(DataOutputStream dos) throws IOException {
        ItemGlobalReplacementCache.writeStringMap(dos, this.replacedItems);
        ItemGlobalReplacementCache.writeStringMap(dos, this.replacedTags);
        ItemGlobalReplacementCache.writeStringMap(dos, this.resultItems);
        ItemGlobalReplacementCache.writeStringMap(dos, this.resultTags);
    }

    public static boolean isItemUsedAsResult(String itemId) {
        return INSTANCE.withInitializedReadLock(() -> ItemGlobalReplacementCache.isValidString(itemId) && ItemGlobalReplacementCache.INSTANCE.resultItems.containsKey(itemId));
    }

    public static Set<String> getAllReplacedItems() {
        return INSTANCE.withInitializedReadLock(() -> new HashSet<String>(ItemGlobalReplacementCache.INSTANCE.replacedItems.keySet()));
    }
}

