/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.components;

import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TagDisplayWidget
extends AbstractWidget {
    private final ResourceLocation tagId;
    private final Button.OnPress removeAction;
    private final Font font;
    private long hoverStartTime;
    private int scrollOffset;
    private boolean isScrolling;
    private static final int SCROLL_DELAY = 250;
    private long lastScrollTime;
    private static final int SCROLL_INTERVAL = 60;
    private static final ResourceLocation ITEM_BOX_TEX = new ResourceLocation("oneenoughitem", "textures/gui/item_box.png");
    private static final ResourceLocation CROSS_TEX = new ResourceLocation("oneenoughitem", "textures/gui/cross.png");

    public TagDisplayWidget(int x, int y, ResourceLocation tagId, Button.OnPress removeAction) {
        super(x, y, 70, 20, (Component)Component.m_237119_());
        this.font = Minecraft.m_91087_().f_91062_;
        this.hoverStartTime = 0L;
        this.scrollOffset = 0;
        this.isScrolling = false;
        this.lastScrollTime = 0L;
        this.tagId = tagId;
        this.removeAction = removeAction;
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        GuiUtils.drawItemBox(graphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_);
        String fullTagText = "#" + this.tagId.toString();
        Object displayText = fullTagText;
        int textX = this.m_252754_() + 3;
        if (this.m_274382_()) {
            int availableWidth;
            if (this.hoverStartTime == 0L) {
                this.hoverStartTime = System.currentTimeMillis();
                this.scrollOffset = 0;
                this.isScrolling = false;
            }
            long hoverDuration = System.currentTimeMillis() - this.hoverStartTime;
            int textWidth = this.font.m_92895_(fullTagText);
            if (textWidth > (availableWidth = this.f_93618_ - 6 - (this.removeAction != null ? 12 : 0)) && hoverDuration > 250L) {
                this.isScrolling = true;
                int maxScroll = textWidth - availableWidth + 20;
                long now = System.currentTimeMillis();
                if (now - this.lastScrollTime > 60L) {
                    ++this.scrollOffset;
                    this.lastScrollTime = now;
                }
                if (this.scrollOffset > maxScroll) {
                    this.scrollOffset = -50;
                }
                textX = this.m_252754_() + 3 - this.scrollOffset;
            } else if (textWidth > availableWidth) {
                displayText = this.truncateText(fullTagText, availableWidth);
            }
        } else {
            this.hoverStartTime = 0L;
            this.scrollOffset = 0;
            this.isScrolling = false;
            int availableWidth = this.f_93618_ - 6 - (this.removeAction != null ? 12 : 0);
            if (this.font.m_92895_(fullTagText) > availableWidth) {
                displayText = this.truncateText(fullTagText, availableWidth);
            }
        }
        if (this.isScrolling) {
            int clipX = this.m_252754_() + 3;
            int clipY = this.m_252907_();
            int clipWidth = this.f_93618_ - 6 - (this.removeAction != null ? 12 : 0);
            int clipHeight = this.f_93619_;
            graphics.m_280588_(clipX, clipY, clipX + clipWidth, clipY + clipHeight);
        }
        graphics.m_280056_(this.font, (String)displayText, textX, this.m_252907_() + 6, -1, false);
        if (this.isScrolling) {
            graphics.m_280618_();
        }
        if (this.m_274382_() && this.removeAction != null) {
            int crossX = this.m_252754_() + this.f_93618_ - 9;
            int crossY = this.m_252907_() + 1;
            graphics.m_280163_(CROSS_TEX, crossX, crossY, 0.0f, 0.0f, 8, 8, 8, 8);
        }
    }

    private String truncateText(String text, int maxWidth) {
        if (this.font.m_92895_(text) <= maxWidth) {
            return text;
        }
        String truncated = text;
        while (this.font.m_92895_(truncated + "...") > maxWidth && truncated.length() > 1) {
            truncated = truncated.substring(0, truncated.length() - 1);
        }
        return truncated + "...";
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_274382_() && this.removeAction != null) {
            int crossX = this.m_252754_() + this.f_93618_ - 9;
            int crossY = this.m_252907_() + 1;
            if (mouseX >= (double)crossX && mouseX <= (double)(crossX + 8) && mouseY >= (double)crossY && mouseY <= (double)(crossY + 8)) {
                this.removeAction.m_93750_(null);
                return true;
            }
        }
        return false;
    }

    public ResourceLocation getTagId() {
        return this.tagId;
    }

    public void m_264152_(int x, int y) {
        this.m_252865_(x);
        this.m_253211_(y);
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)("#" + this.tagId.toString())));
    }
}

