/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.components;

import com.mafuyu404.oneenoughitem.api.DomainRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TagListWidget
extends ObjectSelectionList<TagEntry> {
    private final Consumer<ResourceLocation> onTagSelect;
    private Set<ResourceLocation> selectedTags = Collections.emptySet();

    public TagListWidget(Minecraft minecraft, int width, int height, int y, int itemHeight, Consumer<ResourceLocation> onTagSelect) {
        super(minecraft, width, height, y, y + height, itemHeight);
        this.m_93488_(false);
        this.m_93496_(false);
        this.onTagSelect = onTagSelect;
    }

    public void setTags(List<ResourceLocation> tags) {
        this.m_93516_();
        for (ResourceLocation tag : tags) {
            this.m_7085_((AbstractSelectionList.Entry)new TagEntry(tag));
        }
    }

    public void setSelectedTags(Set<ResourceLocation> selectedTags) {
        this.selectedTags = selectedTags != null ? selectedTags : Collections.emptySet();
    }

    public TagEntry getEntryAtMouse(double mouseX, double mouseY) {
        int relativeY;
        int index;
        if (mouseX >= (double)this.f_93393_ && mouseX <= (double)(this.f_93393_ + this.f_93388_) && mouseY >= (double)this.f_93390_ && mouseY <= (double)(this.f_93390_ + this.f_93389_) && (index = (relativeY = (int)(mouseY - (double)this.f_93390_ + this.m_93517_())) / this.f_93387_) >= 0 && index < this.m_6702_().size()) {
            return (TagEntry)((Object)this.m_6702_().get(index));
        }
        return null;
    }

    public class TagEntry
    extends ObjectSelectionList.Entry<TagEntry> {
        private final ResourceLocation tagId;

        public TagEntry(ResourceLocation tagId) {
            this.tagId = tagId;
        }

        public void m_6311_(GuiGraphics graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            int textColor;
            if (TagListWidget.this.selectedTags.contains(this.tagId)) {
                graphics.m_280509_(x, y, x + entryWidth, y + entryHeight, -2144097537);
            }
            String tagText = "#" + this.tagId.toString();
            boolean replaced = DomainRegistry.current().runtimeCache().isTagReplaced(this.tagId) || DomainRegistry.current().globalCache().getTagReplacement(this.tagId.toString()) != null;
            int n = textColor = replaced ? -43691 : -1;
            if (isMouseOver && !replaced) {
                textColor = -120;
            }
            graphics.m_280488_(((TagListWidget)TagListWidget.this).f_93386_.f_91062_, tagText, x + 5, y + 5, textColor);
            if (replaced) {
                DomainRegistry.current().uiAdapter().renderTagIndicators(graphics, this.tagId, x + entryWidth - 20, y + 2);
            }
            if (isMouseOver) {
                graphics.m_280666_(((TagListWidget)TagListWidget.this).f_93386_.f_91062_, this.getTooltip(), mouseX, mouseY);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            TagListWidget.this.onTagSelect.accept(this.tagId);
            return true;
        }

        public Component m_142172_() {
            return Component.m_237113_((String)("#" + this.tagId.toString()));
        }

        public List<Component> getTooltip() {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)Component.m_237113_((String)("#" + this.tagId.toString())));
            DomainRegistry.current().uiAdapter().addTagTooltip(tooltip, this.tagId);
            tooltip.add((Component)Component.m_237113_((String)this.tagId.m_135827_()).m_130940_(ChatFormatting.BLUE));
            return tooltip;
        }
    }
}

