/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.editor;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.client.gui.FileSelectionScreen;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.manager.ReplacementEditorManager;
import com.mafuyu404.oneenoughitem.client.gui.util.PathUtils;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class FileActions {
    private final ReplacementEditorManager manager;

    public FileActions(ReplacementEditorManager manager) {
        this.manager = manager;
    }

    public String createFile(String datapackName, String fileName) {
        this.manager.createReplacementFile(datapackName, fileName);
        return this.manager.getCurrentFileName();
    }

    public void saveToJson() {
        this.manager.saveReplacement();
    }

    public void selectFile(Minecraft mc, ReplacementEditorScreen parent) {
        if (mc != null) {
            mc.m_91152_((Screen)new FileSelectionScreen(parent));
        }
    }

    public List<Path> scanReplacementFiles() {
        ArrayList<Path> jsonFiles;
        block8: {
            jsonFiles = new ArrayList<Path>();
            try {
                Path replacementsPath = PathUtils.getReplacementsPath();
                if (!Files.exists(replacementsPath, new LinkOption[0])) break block8;
                try (Stream<Path> paths = Files.walk(replacementsPath, new FileVisitOption[0]);){
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().toLowerCase().endsWith(".json")).forEach(jsonFiles::add);
                }
            }
            catch (IOException e) {
                Oneenoughitem.LOGGER.error("Failed to scan replacement files", (Throwable)e);
            }
        }
        return jsonFiles;
    }
}

