/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.client.gui.util;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.api.DomainAdapter;
import com.mafuyu404.oneenoughitem.api.DomainRegistry;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.world.level.storage.LevelResource;

public class PathUtils {
    private static final String FOLDER_DATAPACKS = "datapacks";
    private static final String DEFAULT_DATA_PACK_NAME = "OEIBF";
    private static final String SAVES_FOLDER = "saves";

    public static Path getDatapackPath(String datapackName) {
        Minecraft minecraft = Minecraft.m_91087_();
        Path datapacksPath = PathUtils.getDatapacksPath();
        String finalDatapackName = DEFAULT_DATA_PACK_NAME;
        if (datapackName != null && !datapackName.trim().isEmpty()) {
            finalDatapackName = datapackName.trim();
        }
        return datapacksPath.resolve(finalDatapackName);
    }

    public static Path getReplacementsPath() {
        return PathUtils.getDatapackPath(null).resolve(PathUtils.getReplacementsSubPath());
    }

    private static String getReplacementsSubPath() {
        String domainId;
        try {
            DomainAdapter current = DomainRegistry.current();
            domainId = current != null ? current.id().toLowerCase() : "oei";
        }
        catch (Throwable t) {
            domainId = "oei";
        }
        return "data/" + domainId + "/replacements";
    }

    public static Path getDatapacksPath() {
        Path savesPath;
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_91092_() != null) {
            Path worldPath = minecraft.m_91092_().m_129843_(LevelResource.f_78182_);
            return worldPath.resolve(FOLDER_DATAPACKS);
        }
        if (minecraft.f_91073_ != null) {
            try {
                savesPath = minecraft.f_91069_.toPath().resolve(SAVES_FOLDER);
                Path worldPath = PathUtils.findCurrentWorldPath(savesPath);
                if (worldPath != null) {
                    return worldPath.resolve(FOLDER_DATAPACKS);
                }
            }
            catch (Exception e) {
                Oneenoughitem.LOGGER.warn("Failed to determine world path", (Throwable)e);
            }
        }
        savesPath = minecraft.f_91069_.toPath().resolve(SAVES_FOLDER);
        return savesPath.resolve(FOLDER_DATAPACKS);
    }

    public static String getReplacementsSubPath(String domainId) {
        String id = domainId != null && !domainId.isEmpty() ? domainId.toLowerCase() : "oei";
        return "data/" + id + "/replacements";
    }

    public static List<FileInfo> scanAllReplacementFiles() {
        return PathUtils.scanAllReplacementFiles(DomainRegistry.currentId());
    }

    public static List<FileInfo> scanAllReplacementFiles(String domainId) {
        ArrayList<FileInfo> jsonFiles = new ArrayList<FileInfo>();
        Path datapacksPath = PathUtils.getDatapacksPath();
        if (!Files.exists(datapacksPath, new LinkOption[0])) {
            Oneenoughitem.LOGGER.warn("Datapacks directory does not exist: {}", (Object)datapacksPath);
            return jsonFiles;
        }
        String replacementsSubPath = PathUtils.getReplacementsSubPath(domainId);
        PathUtils.scanReplacementFilesInPath(datapacksPath, replacementsSubPath, jsonFiles);
        return jsonFiles;
    }

    private static void scanReplacementFilesInPath(Path datapacksPath, String replacementsSubPath, List<FileInfo> jsonFiles) {
        try (Stream<Path> datapackDirs = Files.list(datapacksPath);){
            datapackDirs.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(datapackDir -> {
                Path replacementsPath = datapackDir.resolve(replacementsSubPath);
                if (Files.exists(replacementsPath, new LinkOption[0])) {
                    PathUtils.scanJsonFilesInDirectory(replacementsPath, datapackDir, jsonFiles);
                }
            });
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.error("Failed to list datapack directories", (Throwable)e);
        }
    }

    private static void scanJsonFilesInDirectory(Path replacementsPath, Path datapackRoot, List<FileInfo> jsonFiles) {
        try (Stream<Path> paths = Files.walk(replacementsPath, new FileVisitOption[0]);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().toLowerCase().endsWith(".json")).forEach(path -> {
                String fileName = path.getFileName().toString();
                String displayName = fileName.endsWith(".json") ? fileName.substring(0, fileName.length() - 5) : fileName;
                String datapackName = datapackRoot.getFileName().toString();
                Path relativeToReplacements = replacementsPath.relativize(path.getParent());
                String relativePathStr = relativeToReplacements.toString().equals(".") ? "" : relativeToReplacements.toString();
                String fullPath = String.join((CharSequence)"/", FOLDER_DATAPACKS, datapackName, PathUtils.getReplacementsSubPath(), relativePathStr).replaceAll("\\\\", "/");
                jsonFiles.add(new FileInfo(displayName, (Path)path, fullPath, datapackName));
            });
        }
        catch (IOException e) {
            Oneenoughitem.LOGGER.error("Failed to scan files in directory: {}", (Object)replacementsPath, (Object)e);
        }
    }

    public static Path findCurrentWorldPath(Path savesPath) {
        Path path2;
        block9: {
            if (!Files.exists(savesPath, new LinkOption[0])) {
                return null;
            }
            Stream<Path> stream = Files.list(savesPath);
            try {
                path2 = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(path -> Files.exists(path.resolve("level.dat"), new LinkOption[0])).max((p1, p2) -> {
                    try {
                        return Files.getLastModifiedTime(p1, new LinkOption[0]).compareTo(Files.getLastModifiedTime(p2, new LinkOption[0]));
                    }
                    catch (IOException e) {
                        return 0;
                    }
                }).orElse(null);
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Oneenoughitem.LOGGER.error("Error finding current world path", (Throwable)e);
                    return null;
                }
            }
            stream.close();
        }
        return path2;
    }

    public record FileInfo(String displayName, Path filePath, String fullPath, String datapackName) {
    }
}

