/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.event.base;

import com.mafuyu404.oelib.forge.data.DataManager;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.data.Replacements;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public abstract class AbstractReplacementEventHandler {
    protected abstract void clearModuleCache();

    protected abstract void putToModuleCache(Replacements var1);

    protected abstract boolean tryResolveData(String var1);

    protected abstract boolean tryResolveTag(String var1);

    protected Replacements buildReplacements(Replacements r) {
        return r;
    }

    private boolean isValidForCurrentDomain(Replacements r) {
        boolean resultOk;
        String result = r.result();
        if (result == null || result.isBlank()) {
            return false;
        }
        boolean bl = resultOk = result.startsWith("#") ? this.tryResolveTag(result.substring(1)) : this.tryResolveData(result);
        if (!resultOk) {
            return false;
        }
        for (String id : r.match()) {
            boolean ok;
            if (id == null || id.isBlank() || !(ok = id.startsWith("#") ? this.tryResolveTag(id.substring(1)) : this.tryResolveData(id))) continue;
            return true;
        }
        return false;
    }

    protected boolean acceptLocation(ResourceLocation location) {
        return true;
    }

    public void rebuildReplacementCache(String reason, DataManager<Replacements> manager) {
        if (manager == null) {
            Oneenoughitem.LOGGER.warn("No replacement data manager found (reason: {})", (Object)reason);
            return;
        }
        this.clearModuleCache();
        for (Map.Entry e : manager.getAllData().entrySet()) {
            Replacements rr;
            ResourceLocation location = (ResourceLocation)e.getKey();
            if (!this.acceptLocation(location) || !this.isValidForCurrentDomain(rr = this.buildReplacements((Replacements)e.getValue()))) continue;
            this.putToModuleCache(rr);
        }
        Oneenoughitem.LOGGER.debug("Rebuilt replacement cache (reason: {})", (Object)reason);
    }
}

