/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.init.config;

import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.AutoInitConfigContainer;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.config.DefaultRulesEntry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public abstract class DomainConfig
extends AutoInitConfigContainer {
    public final String domainId;
    public final IConfigEntry<DefaultRules> DEFAULT_RULES;
    private static final Map<String, DomainConfig> DOMAIN_CONFIGS = new HashMap<String, DomainConfig>();

    protected DomainConfig(String domainId, String configFileName, DefaultRules defaultRules) {
        super(new ResourceLocation("oneenoughitem", domainId + "_common_config"), "config." + domainId + ".common.title", "./config/" + domainId + "/" + configFileName);
        this.domainId = domainId;
        this.DEFAULT_RULES = new DefaultRulesEntry("config." + domainId + ".default_rules", defaultRules, DefaultRules.CODEC).json("Default_Rules");
        ConfigManager.getInstance().registerConfigHandler((AbstractConfigContainer)this);
        ServerConfigManager.registerServerConfig((AbstractConfigContainer)this, (ServerConfigManager.PermissionChecker)ServerConfigManager.PermissionChecker.IS_OPERATOR);
        if (DOMAIN_CONFIGS.containsKey(domainId)) {
            throw new IllegalStateException("Domain config for '" + domainId + "' already registered!");
        }
        DOMAIN_CONFIGS.put(domainId, this);
    }

    public void init() {
    }

    public static DomainConfig get(String domainId) {
        return DOMAIN_CONFIGS.get(domainId);
    }

    public static DefaultRules getDefaultRules(String domainId) {
        DomainConfig cfg = DOMAIN_CONFIGS.get(domainId);
        return cfg != null ? (DefaultRules)cfg.DEFAULT_RULES.getValue() : null;
    }

    public record DefaultRules(Optional<Map<String, Replacements.ProcessingMode>> data, Optional<Map<String, Replacements.ProcessingMode>> tag) {
        public static final Codec<DefaultRules> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, Replacements.ProcessingMode.CODEC).optionalFieldOf("data").forGetter(DefaultRules::data), (App)Codec.unboundedMap((Codec)Codec.STRING, Replacements.ProcessingMode.CODEC).optionalFieldOf("tag").forGetter(DefaultRules::tag)).apply((Applicative)instance, DefaultRules::new));

        public Replacements.Rules toRules() {
            return new Replacements.Rules(this.data, this.tag);
        }
    }
}

