/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.mixin;

import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.ItemReplacementCache;
import com.mafuyu404.oneenoughitem.init.config.DomainConfig;
import com.mafuyu404.oneenoughitem.init.config.OEIConfig;
import com.mafuyu404.oneenoughitem.util.MixinUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagLoader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TagLoader.class})
public abstract class TagLoaderMixin<T> {
    @Shadow
    @Final
    private String f_13449_;
    private static final String ITEMS_TAG_DIR = "tags/items";

    @Inject(method={"load(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/Map;"}, at={@At(value="HEAD")})
    private void oei$beginOverrideForTags(ResourceManager resourceManager, CallbackInfoReturnable<Map<ResourceLocation, List<TagLoader.EntryWithSource>>> cir) {
        if (!ITEMS_TAG_DIR.equals(this.f_13449_)) {
            return;
        }
        try {
            MixinUtils.ReplacementLoader.CurrentSnapshot snapshot = MixinUtils.ReplacementLoader.loadCurrentSnapshot(resourceManager);
            Map<String, String> currentItemMap = snapshot.dataMap();
            if (!currentItemMap.isEmpty() && !ItemReplacementCache.hasReloadOverride()) {
                ItemReplacementCache.beginReloadOverride(currentItemMap);
            }
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("Tag rewrite: begin reload-override failed for directory {}", (Object)this.f_13449_, (Object)e);
        }
    }

    @Inject(method={"load(Lnet/minecraft/server/packs/resources/ResourceManager;)Ljava/util/Map;"}, at={@At(value="RETURN")})
    private void oei$replaceTagItems(ResourceManager resourceManager, CallbackInfoReturnable<Map<ResourceLocation, List<TagLoader.EntryWithSource>>> cir) {
        String tagType = this.getTagType(this.f_13449_);
        if (tagType == null) {
            return;
        }
        Map tags = (Map)cir.getReturnValue();
        if (tags == null || tags.isEmpty()) {
            return;
        }
        Map<Object, Object> currentItemMap = Collections.emptyMap();
        Map<Object, Object> currentItemRules = Collections.emptyMap();
        try {
            MixinUtils.ReplacementLoader.CurrentSnapshot snapshot = MixinUtils.ReplacementLoader.loadCurrentSnapshot(resourceManager);
            currentItemMap = snapshot.dataMap();
            currentItemRules = snapshot.dataRules();
        }
        catch (Exception e) {
            Oneenoughitem.LOGGER.warn("Tag rewrite: failed to load current replacements (will fallback to cache if empty)", (Throwable)e);
        }
        boolean fallbackEnabled = currentItemMap.isEmpty();
        Replacements.Rules defaultRules = null;
        try {
            DomainConfig.DefaultRules dr = OEIConfig.getDefaultRules("oei");
            if (dr != null) {
                defaultRules = dr.toRules();
            }
        }
        catch (Exception dr) {
            // empty catch block
        }
        int totalTags = 0;
        int totalDropped = 0;
        for (Map.Entry tagEntry : tags.entrySet()) {
            ResourceLocation tagId = (ResourceLocation)tagEntry.getKey();
            List entries = (List)tagEntry.getValue();
            if (entries == null || entries.isEmpty()) continue;
            Iterator iterator = entries.iterator();
            int dropped = 0;
            boolean touched = false;
            while (iterator.hasNext()) {
                TagLoader.EntryWithSource tracked = (TagLoader.EntryWithSource)iterator.next();
                TagEntry e = tracked.f_216042_();
                if (e.isTag()) continue;
                ResourceLocation fromId = e.getId();
                String fromStr = fromId.toString();
                String mapped = (String)currentItemMap.get(fromStr);
                if (mapped == null && fallbackEnabled) {
                    mapped = ItemReplacementCache.matchItem(fromStr);
                }
                if (mapped == null) continue;
                boolean shouldReplace = false;
                Replacements.Rules rules = (Replacements.Rules)currentItemRules.get(fromStr);
                if (rules == null) {
                    rules = defaultRules;
                }
                if (rules != null) {
                    shouldReplace = rules.tag().map(m -> (Replacements.ProcessingMode)((Object)((Object)m.get(tagType)))).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(false);
                } else if (fallbackEnabled) {
                    shouldReplace = ItemReplacementCache.shouldReplaceInTagType(fromStr, tagType);
                }
                if (!shouldReplace) continue;
                iterator.remove();
                ++dropped;
                touched = true;
                Oneenoughitem.LOGGER.debug("Item tag rewrite: drop '{}' from {} (replaced by '{}', rule={})", (Object)fromStr, (Object)tagId, (Object)mapped, (Object)tagType);
            }
            if (!touched) continue;
            ++totalTags;
            totalDropped += dropped;
            Oneenoughitem.LOGGER.info("Item tag rewrite: {} -> dropped={}", (Object)tagId, (Object)dropped);
        }
        if (totalTags > 0) {
            Oneenoughitem.LOGGER.info("Item tags rewrite summary (rule-based): affectedTags={}, totalDropped={}", (Object)totalTags, (Object)totalDropped);
        }
    }

    private String getTagType(String directory) {
        return ITEMS_TAG_DIR.equals(directory) ? "items" : null;
    }
}

