/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oneenoughitem.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mafuyu404.oneenoughitem.Oneenoughitem;
import com.mafuyu404.oneenoughitem.api.ReplacementStrategy;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.AbstractReplacementStrategy;
import com.mafuyu404.oneenoughitem.init.ItemReplacementCache;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

public class MixinUtils {
    private static ReplacementStrategy STRATEGY;

    public static void setStrategy(ReplacementStrategy strategy) {
        STRATEGY = strategy;
    }

    public static ReplacementStrategy getStrategy() {
        return STRATEGY;
    }

    public static FieldRule getDataDirFieldRule(String directory) {
        return switch (directory) {
            case "recipes" -> new FieldRule(Set.of("item", "id", "result"), true);
            case "advancements" -> new FieldRule(Set.of("item"), true);
            case "loot_tables" -> new FieldRule(Set.of("name"), true);
            default -> new FieldRule(Set.of("item", "id", "result"), false);
        };
    }

    public record FieldRule(Set<String> keys, boolean strict) {
    }

    public static class ReplacementLoader {
        public static CurrentSnapshot loadCurrentSnapshot(ResourceManager resourceManager) {
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap<String, Replacements.Rules> itemRules = new HashMap<String, Replacements.Rules>();
            HashMap<String, Replacements.Rules> tagRules = new HashMap<String, Replacements.Rules>();
            Predicate<ResourceLocation> jsonPredicate = rl -> rl.m_135815_().endsWith(".json") && "oei".equals(rl.m_135827_());
            for (String baseDir : AbstractReplacementStrategy.REPLACEMENT_DIR_CANDIDATES) {
                try {
                    Map res = resourceManager.m_214159_(baseDir, jsonPredicate);
                    if (res.isEmpty()) continue;
                    for (Map.Entry e : res.entrySet()) {
                        try {
                            BufferedReader reader = ((Resource)e.getValue()).m_215508_();
                            try {
                                JsonElement root = JsonParser.parseReader((Reader)reader);
                                ReplacementLoader.parseReplacementJson(root, map, itemRules, tagRules);
                            }
                            finally {
                                if (reader == null) continue;
                                ((Reader)reader).close();
                            }
                        }
                        catch (Exception ex) {
                            LogHelper.logParseError((ResourceLocation)e.getKey(), ex);
                        }
                    }
                }
                catch (Exception exception) {
                }
            }
            return new CurrentSnapshot(map, itemRules, tagRules);
        }

        public static void parseReplacementJson(JsonElement root, Map<String, String> outMap, Map<String, Replacements.Rules> outItemRules, Map<String, Replacements.Rules> outTagRules) {
            block10: {
                if (root == null) {
                    return;
                }
                if (root.isJsonArray()) {
                    for (JsonElement el : root.getAsJsonArray()) {
                        ReplacementLoader.parseReplacementJson(el, outMap, outItemRules, outTagRules);
                    }
                    return;
                }
                if (!root.isJsonObject()) break block10;
                JsonObject obj = root.getAsJsonObject();
                if (obj.has("matchItems") && obj.get("matchItems").isJsonArray() && obj.has("resultItems")) {
                    String result = obj.get("resultItems").getAsString();
                    JsonArray arr = obj.get("matchItems").getAsJsonArray();
                    Replacements.Rules rules = null;
                    if (obj.has("rules") && obj.get("rules").isJsonObject()) {
                        rules = ReplacementLoader.parseRulesObject(obj.getAsJsonObject("rules"));
                    }
                    for (JsonElement el : arr) {
                        String src;
                        if (!el.isJsonPrimitive() || !el.getAsJsonPrimitive().isString() || (src = el.getAsString()) == null || src.isEmpty()) continue;
                        if (src.startsWith("#")) {
                            String tagId = src.substring(1);
                            if (rules != null) {
                                outTagRules.put(tagId, rules);
                            }
                            outMap.put(src, result);
                            continue;
                        }
                        outMap.put(src, result);
                        if (rules == null) continue;
                        outItemRules.put(src, rules);
                    }
                } else {
                    for (Map.Entry e : obj.entrySet()) {
                        ReplacementLoader.parseReplacementJson((JsonElement)e.getValue(), outMap, outItemRules, outTagRules);
                    }
                }
            }
        }

        private static Replacements.Rules parseRulesObject(JsonObject rulesObj) {
            Optional<Map<String, Replacements.ProcessingMode>> dataOpt = Optional.empty();
            Optional<Map<String, Replacements.ProcessingMode>> tagOpt = Optional.empty();
            if (rulesObj.has("data") && rulesObj.get("data").isJsonObject()) {
                Map<String, Replacements.ProcessingMode> data = ReplacementLoader.parseModeMap(rulesObj.getAsJsonObject("data"));
                Optional<Object> optional = dataOpt = data.isEmpty() ? Optional.empty() : Optional.of(data);
            }
            if (rulesObj.has("tag") && rulesObj.get("tag").isJsonObject()) {
                Map<String, Replacements.ProcessingMode> tag = ReplacementLoader.parseModeMap(rulesObj.getAsJsonObject("tag"));
                Optional<Object> optional = tagOpt = tag.isEmpty() ? Optional.empty() : Optional.of(tag);
            }
            if (dataOpt.isEmpty() && tagOpt.isEmpty()) {
                return null;
            }
            return new Replacements.Rules(dataOpt, tagOpt);
        }

        private static Map<String, Replacements.ProcessingMode> parseModeMap(JsonObject obj) {
            HashMap<String, Replacements.ProcessingMode> map = new HashMap<String, Replacements.ProcessingMode>();
            for (Map.Entry entry : obj.entrySet()) {
                JsonElement value = (JsonElement)entry.getValue();
                if (!value.isJsonPrimitive() || !value.getAsJsonPrimitive().isString()) continue;
                String stringValue = value.getAsString();
                try {
                    Replacements.ProcessingMode mode = Replacements.ProcessingMode.valueOf(stringValue.toUpperCase());
                    map.put((String)entry.getKey(), mode);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return map;
        }

        public record CurrentSnapshot(Map<String, String> dataMap, Map<String, Replacements.Rules> dataRules, Map<String, Replacements.Rules> tagRules) {
        }
    }

    public static class IdReplacer {
        public static void replaceIdCommon(String id, ReplaceContext ctx, BiConsumer<String, String> logReplaceAction, Consumer<JsonElement> setValueAction) {
            String target = TargetResolver.resolveTarget(id, ctx);
            if (target == null) {
                return;
            }
            boolean shouldProcess = false;
            if (ctx.dataRules != null) {
                Replacements.Rules rules = ctx.dataRules.get(id);
                if (rules != null) {
                    shouldProcess = rules.data().map(m -> (Replacements.ProcessingMode)((Object)((Object)m.get(ctx.dataType)))).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(false);
                } else if (ctx.allowCacheFallback) {
                    shouldProcess = ItemReplacementCache.shouldReplaceInDataDir(id, ctx.dataType);
                }
            } else if (ctx.allowCacheFallback) {
                shouldProcess = ItemReplacementCache.shouldReplaceInDataDir(id, ctx.dataType);
            }
            if (!shouldProcess) {
                return;
            }
            if ("minecraft:air".equals(target)) {
                ctx.shouldDrop = true;
                LogHelper.logDrop(ctx.dataType, id, target, ctx.lastMappingOrigin, "mapping");
                return;
            }
            if (!target.equals(id)) {
                setValueAction.accept((JsonElement)new JsonPrimitive(target));
                ctx.mutated = true;
                logReplaceAction.accept(id, target);
            }
            if (ctx.rule.strict() && TargetResolver.isSourceIdWithCurrent(id, ctx)) {
                ctx.shouldDrop = true;
                LogHelper.logDrop(ctx.dataType, id, ctx.lastMappingOrigin, ctx.lastMappingOrigin, "strict residual source-id");
            }
        }

        public static void tryReplaceId(JsonObject obj, String key, String id, ReplaceContext ctx) {
            IdReplacer.replaceIdCommon(id, ctx, (oldId, newId) -> LogHelper.logReplace(ctx.dataType, oldId, newId, ctx.lastMappingOrigin, false), value -> obj.add(key, value));
        }

        public static void tryReplaceId(JsonArray array, int index, String id, ReplaceContext ctx) {
            IdReplacer.replaceIdCommon(id, ctx, (oldId, newId) -> LogHelper.logReplace(ctx.dataType, oldId, newId, ctx.lastMappingOrigin, true), value -> array.set(index, value));
        }
    }

    public static class TargetResolver {
        public static String resolveTarget(String id, ReplaceContext ctx) {
            String v;
            if (ctx.dataMap != null && (v = ctx.dataMap.get(id)) != null) {
                ctx.lastMappingOrigin = "CURRENT";
                return v;
            }
            if (ctx.allowCacheFallback && (v = ItemReplacementCache.matchItem(id)) != null) {
                ctx.lastMappingOrigin = "CACHE";
                return v;
            }
            ctx.lastMappingOrigin = "N/A";
            return null;
        }

        public static boolean isSourceIdWithCurrent(String id, ReplaceContext ctx) {
            if (ctx.sourceDataIds != null && ctx.sourceDataIds.contains(id)) {
                return true;
            }
            return ctx.allowCacheFallback && ItemReplacementCache.isSourceItemId(id);
        }
    }

    public static class LogHelper {
        public static void logDrop(String directory, String id, String target, String origin, String reason) {
            Oneenoughitem.LOGGER.debug("Drop by {} in {}: {} -> {} (origin={})", (Object)reason, (Object)directory, (Object)id, (Object)target, (Object)origin);
        }

        public static void logReplace(String directory, String id, String target, String origin, boolean isArray) {
            String prefix = isArray ? "Replaced array id" : "Replaced id";
            Oneenoughitem.LOGGER.debug("{} in {}: {} -> {} (origin={})", (Object)prefix, (Object)directory, (Object)id, (Object)target, (Object)origin);
        }

        public static void logFileOperation(String operation, ResourceLocation key, String directory, Object ... params) {
            switch (operation) {
                case "dropped": {
                    Oneenoughitem.LOGGER.debug("Dropped {} in {} (origin={}, reason=rule)", (Object)key, (Object)directory, params[0]);
                    break;
                }
                case "rewritten": {
                    Oneenoughitem.LOGGER.debug("Rewritten {} in {} (mode={}, fallbackCache={})", (Object)key, (Object)directory, params[0], params[1]);
                }
            }
        }

        public static void logSummary(String directory, int replaced, int dropped, String mode, boolean fallbackCache) {
            Oneenoughitem.LOGGER.debug("OEI JSON rewrite in '{}': replaced={}, dropped={}, mode={}, fallbackCache={}", (Object)directory, (Object)replaced, (Object)dropped, (Object)mode, (Object)fallbackCache);
        }

        public static void logError(String operation, ResourceLocation key, String directory, Exception e) {
            Oneenoughitem.LOGGER.debug("OEI {} failed for {} in '{}'", (Object)operation, (Object)key, (Object)directory, (Object)e);
        }

        public static void logParseError(ResourceLocation key, Exception ex) {
            Oneenoughitem.LOGGER.debug("Failed parsing replacements at {}: {}", (Object)key, (Object)ex.toString());
        }
    }

    public static final class ReplaceContext {
        public final String dataType;
        public final FieldRule rule;
        public final Map<String, String> dataMap;
        public final Set<String> sourceDataIds;
        public boolean mutated = false;
        public boolean shouldDrop = false;
        public boolean allowCacheFallback;
        public String lastMappingOrigin = "N/A";
        public final Map<String, Replacements.Rules> dataRules;

        public ReplaceContext(String dataType, FieldRule rule, Map<String, String> dataMap, Set<String> sourceDataIds, Map<String, Replacements.Rules> dataRules) {
            this.dataType = dataType;
            this.rule = rule;
            this.dataMap = dataMap;
            this.sourceDataIds = sourceDataIds;
            this.dataRules = dataRules;
            this.allowCacheFallback = dataMap == null || dataMap.isEmpty();
        }
    }
}

