/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.bstats.json;

import java.util.Arrays;
import java.util.stream.Collectors;
import me.spartacus04.instantrestock.dependencies.instantrestock.bstats.json.JsonObjectBuilder$JsonObject;

public class JsonObjectBuilder {
    private StringBuilder builder = new StringBuilder();
    private boolean hasAtLeastOneField = false;

    public JsonObjectBuilder() {
        this.builder.append("{");
    }

    public JsonObjectBuilder appendNull(String string) {
        this.appendFieldUnescaped(string, "null");
        return this;
    }

    public JsonObjectBuilder appendField(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("JSON value must not be null");
        }
        this.appendFieldUnescaped(string, "\"" + JsonObjectBuilder.escape(string2) + "\"");
        return this;
    }

    public JsonObjectBuilder appendField(String string, int n) {
        this.appendFieldUnescaped(string, String.valueOf(n));
        return this;
    }

    public JsonObjectBuilder appendField(String string, JsonObjectBuilder$JsonObject jsonObjectBuilder$JsonObject) {
        if (jsonObjectBuilder$JsonObject == null) {
            throw new IllegalArgumentException("JSON object must not be null");
        }
        this.appendFieldUnescaped(string, jsonObjectBuilder$JsonObject.toString());
        return this;
    }

    public JsonObjectBuilder appendField(String string2, String[] object) {
        if (object == null) {
            throw new IllegalArgumentException("JSON values must not be null");
        }
        object = Arrays.stream(object).map(string -> "\"" + JsonObjectBuilder.escape(string) + "\"").collect(Collectors.joining(","));
        this.appendFieldUnescaped(string2, "[" + (String)object + "]");
        return this;
    }

    public JsonObjectBuilder appendField(String string, int[] object) {
        if (object == null) {
            throw new IllegalArgumentException("JSON values must not be null");
        }
        object = Arrays.stream(object).mapToObj(String::valueOf).collect(Collectors.joining(","));
        this.appendFieldUnescaped(string, "[" + (String)object + "]");
        return this;
    }

    public JsonObjectBuilder appendField(String string, JsonObjectBuilder$JsonObject[] object) {
        if (object == null) {
            throw new IllegalArgumentException("JSON values must not be null");
        }
        object = Arrays.stream(object).map(JsonObjectBuilder$JsonObject::toString).collect(Collectors.joining(","));
        this.appendFieldUnescaped(string, "[" + (String)object + "]");
        return this;
    }

    private void appendFieldUnescaped(String string, String string2) {
        if (this.builder == null) {
            throw new IllegalStateException("JSON has already been built");
        }
        if (string == null) {
            throw new IllegalArgumentException("JSON key must not be null");
        }
        if (this.hasAtLeastOneField) {
            this.builder.append(",");
        }
        this.builder.append("\"").append(JsonObjectBuilder.escape(string)).append("\":").append(string2);
        this.hasAtLeastOneField = true;
    }

    public JsonObjectBuilder$JsonObject build() {
        if (this.builder == null) {
            throw new IllegalStateException("JSON has already been built");
        }
        JsonObjectBuilder$JsonObject jsonObjectBuilder$JsonObject = new JsonObjectBuilder$JsonObject(this.builder.append("}").toString(), null);
        this.builder = null;
        return jsonObjectBuilder$JsonObject;
    }

    private static String escape(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c <= '\u000f') {
                stringBuilder.append("\\u000").append(Integer.toHexString(c));
                continue;
            }
            if (c <= '\u001f') {
                stringBuilder.append("\\u00").append(Integer.toHexString(c));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }
}

