/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.InstanceCreator;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonIOException;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.ReflectionAccessFilter;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.ReflectionAccessFilter$FilterResult;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.GsonTypes;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.LinkedTreeMap;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.ObjectConstructor;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.ReflectionAccessFilterHelper;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.TroubleshootingGuide;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.UnsafeAllocator;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.reflect.ReflectionHelper;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.reflect.TypeToken;

public final class ConstructorConstructor {
    private final Map<Type, InstanceCreator<?>> instanceCreators;
    private final boolean useJdkUnsafe;
    private final List<ReflectionAccessFilter> reflectionFilters;

    public ConstructorConstructor(Map<Type, InstanceCreator<?>> map, boolean bl, List<ReflectionAccessFilter> list) {
        this.instanceCreators = map;
        this.useJdkUnsafe = bl;
        this.reflectionFilters = list;
    }

    static String checkInstantiable(Class<?> clazz) {
        int n = clazz.getModifiers();
        if (Modifier.isInterface(n)) {
            return "Interfaces can't be instantiated! Register an InstanceCreator or a TypeAdapter for this type. Interface name: " + clazz.getName();
        }
        if (Modifier.isAbstract(n)) {
            return "Abstract classes can't be instantiated! Adjust the R8 configuration or register an InstanceCreator or a TypeAdapter for this type. Class name: " + clazz.getName() + "\nSee " + TroubleshootingGuide.createUrl("r8-abstract-class");
        }
        return null;
    }

    public final <T> ObjectConstructor<T> get(TypeToken<T> typeToken) {
        return this.get(typeToken, true);
    }

    public final <T> ObjectConstructor<T> get(TypeToken<T> object, boolean bl) {
        Object object2 = ((TypeToken)object).getType();
        object = ((TypeToken)object).getRawType();
        Object object3 = this.instanceCreators.get(object2);
        if (object3 != null) {
            return () -> ConstructorConstructor.lambda$get$0(object3, (Type)object2);
        }
        object3 = this.instanceCreators.get(object);
        if (object3 != null) {
            return () -> ConstructorConstructor.lambda$get$1(object3, (Type)object2);
        }
        object3 = ConstructorConstructor.newSpecialCollectionConstructor((Type)object2, object);
        if (object3 != null) {
            return object3;
        }
        object3 = ReflectionAccessFilterHelper.getFilterResult(this.reflectionFilters, object);
        ObjectConstructor<T> objectConstructor = ConstructorConstructor.newDefaultConstructor(object, (ReflectionAccessFilter$FilterResult)((Object)object3));
        if (objectConstructor != null) {
            return objectConstructor;
        }
        if ((object2 = ConstructorConstructor.newDefaultImplementationConstructor((Type)object2, object)) != null) {
            return object2;
        }
        object2 = ConstructorConstructor.checkInstantiable(object);
        if (object2 != null) {
            return () -> ConstructorConstructor.lambda$get$2((String)object2);
        }
        if (!bl) {
            object = "Unable to create instance of " + object + "; Register an InstanceCreator or a TypeAdapter for this type.";
            return () -> ConstructorConstructor.lambda$get$3((String)object);
        }
        if (object3 != ReflectionAccessFilter$FilterResult.ALLOW) {
            object = "Unable to create instance of " + object + "; ReflectionAccessFilter does not permit using reflection or Unsafe. Register an InstanceCreator or a TypeAdapter for this type or adjust the access filter to allow using reflection.";
            return () -> ConstructorConstructor.lambda$get$4((String)object);
        }
        return this.newUnsafeAllocator((Class<? super T>)object);
    }

    private static <T> ObjectConstructor<T> newSpecialCollectionConstructor(Type type, Class<? super T> clazz) {
        if (EnumSet.class.isAssignableFrom(clazz)) {
            return () -> {
                if (type instanceof ParameterizedType) {
                    Type type = ((ParameterizedType)type).getActualTypeArguments()[0];
                    if (type instanceof Class) {
                        type = EnumSet.noneOf((Class)type);
                        return type;
                    }
                    throw new JsonIOException("Invalid EnumSet type: " + type.toString());
                }
                throw new JsonIOException("Invalid EnumSet type: " + type.toString());
            };
        }
        if (clazz == EnumMap.class) {
            return () -> {
                if (type instanceof ParameterizedType) {
                    Type type = ((ParameterizedType)type).getActualTypeArguments()[0];
                    if (type instanceof Class) {
                        type = new EnumMap((Class)type);
                        return type;
                    }
                    throw new JsonIOException("Invalid EnumMap type: " + type.toString());
                }
                throw new JsonIOException("Invalid EnumMap type: " + type.toString());
            };
        }
        return null;
    }

    private static <T> ObjectConstructor<T> newDefaultConstructor(Class<? super T> object, ReflectionAccessFilter$FilterResult reflectionAccessFilter$FilterResult) {
        Constructor constructor;
        if (Modifier.isAbstract(((Class)object).getModifiers())) {
            return null;
        }
        try {
            constructor = ((Class)object).getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        boolean bl = reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.ALLOW || ReflectionAccessFilterHelper.canAccess(constructor, null) && (reflectionAccessFilter$FilterResult != ReflectionAccessFilter$FilterResult.BLOCK_ALL || Modifier.isPublic(constructor.getModifiers()));
        if (!bl) {
            object = "Unable to invoke no-args constructor of " + object + "; constructor is not accessible and ReflectionAccessFilter does not permit making it accessible. Register an InstanceCreator or a TypeAdapter for this type, change the visibility of the constructor or adjust the access filter.";
            return () -> ConstructorConstructor.lambda$newDefaultConstructor$7((String)object);
        }
        if (reflectionAccessFilter$FilterResult == ReflectionAccessFilter$FilterResult.ALLOW && (object = ReflectionHelper.tryMakeAccessible(constructor)) != null) {
            return () -> ConstructorConstructor.lambda$newDefaultConstructor$8((String)object);
        }
        return () -> {
            try {
                Object t = constructor.newInstance(new Object[0]);
                return t;
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(constructor) + "' with no args", instantiationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException("Failed to invoke constructor '" + ReflectionHelper.constructorToString(constructor) + "' with no args", invocationTargetException.getCause());
            }
            catch (IllegalAccessException illegalAccessException) {
                IllegalAccessException illegalAccessException2 = illegalAccessException;
                throw ReflectionHelper.createExceptionForUnexpectedIllegalAccess(illegalAccessException);
            }
        };
    }

    private static <T> ObjectConstructor<T> newDefaultImplementationConstructor(Type objectConstructor, Class<? super T> clazz) {
        if (Collection.class.isAssignableFrom(clazz)) {
            objectConstructor = ConstructorConstructor.newCollectionConstructor(clazz);
            return objectConstructor;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            objectConstructor = ConstructorConstructor.newMapConstructor((Type)((Object)objectConstructor), clazz);
            return objectConstructor;
        }
        return null;
    }

    private static ObjectConstructor<? extends Collection<? extends Object>> newCollectionConstructor(Class<?> clazz) {
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return () -> new ArrayList();
        }
        if (clazz.isAssignableFrom(LinkedHashSet.class)) {
            return () -> new LinkedHashSet();
        }
        if (clazz.isAssignableFrom(TreeSet.class)) {
            return () -> new TreeSet();
        }
        if (clazz.isAssignableFrom(ArrayDeque.class)) {
            return () -> new ArrayDeque();
        }
        return null;
    }

    private static boolean hasStringKeyType(Type typeArray) {
        if (!(typeArray instanceof ParameterizedType)) {
            return true;
        }
        if ((typeArray = ((ParameterizedType)typeArray).getActualTypeArguments()).length == 0) {
            return false;
        }
        return GsonTypes.getRawType(typeArray[0]) == String.class;
    }

    private static ObjectConstructor<? extends Map<? extends Object, Object>> newMapConstructor(Type type, Class<?> clazz) {
        if (clazz.isAssignableFrom(LinkedTreeMap.class) && ConstructorConstructor.hasStringKeyType(type)) {
            return () -> new LinkedTreeMap();
        }
        if (clazz.isAssignableFrom(LinkedHashMap.class)) {
            return () -> new LinkedHashMap();
        }
        if (clazz.isAssignableFrom(TreeMap.class)) {
            return () -> new TreeMap();
        }
        if (clazz.isAssignableFrom(ConcurrentHashMap.class)) {
            return () -> new ConcurrentHashMap();
        }
        if (clazz.isAssignableFrom(ConcurrentSkipListMap.class)) {
            return () -> new ConcurrentSkipListMap();
        }
        return null;
    }

    private <T> ObjectConstructor<T> newUnsafeAllocator(Class<? super T> object) {
        if (this.useJdkUnsafe) {
            return () -> {
                try {
                    Object t = UnsafeAllocator.INSTANCE.newInstance(object);
                    return t;
                }
                catch (Exception exception) {
                    throw new RuntimeException("Unable to create instance of " + object + ". Registering an InstanceCreator or a TypeAdapter for this type, or adding a no-args constructor may fix this problem.", exception);
                }
            };
        }
        String string = "Unable to create instance of " + object + "; usage of JDK Unsafe is disabled. Registering an InstanceCreator or a TypeAdapter for this type, adding a no-args constructor, or enabling usage of JDK Unsafe may fix this problem.";
        if (((Class)object).getDeclaredConstructors().length == 0) {
            string = string + " Or adjust your R8 configuration to keep the no-args constructor of the class.";
        }
        object = string;
        return () -> ConstructorConstructor.lambda$newUnsafeAllocator$20((String)object);
    }

    public final String toString() {
        return this.instanceCreators.toString();
    }

    private static /* synthetic */ Object lambda$newUnsafeAllocator$20(String string) {
        throw new JsonIOException(string);
    }

    private static /* synthetic */ Object lambda$newDefaultConstructor$8(String string) {
        throw new JsonIOException(string);
    }

    private static /* synthetic */ Object lambda$newDefaultConstructor$7(String string) {
        throw new JsonIOException(string);
    }

    private static /* synthetic */ Object lambda$get$4(String string) {
        throw new JsonIOException(string);
    }

    private static /* synthetic */ Object lambda$get$3(String string) {
        throw new JsonIOException(string);
    }

    private static /* synthetic */ Object lambda$get$2(String string) {
        throw new JsonIOException(string);
    }

    private static /* synthetic */ Object lambda$get$1(InstanceCreator instanceCreator, Type type) {
        return instanceCreator.createInstance(type);
    }

    private static /* synthetic */ Object lambda$get$0(InstanceCreator instanceCreator, Type type) {
        return instanceCreator.createInstance(type);
    }
}

