/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.bind;

import java.util.ArrayDeque;
import java.util.Map;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonArray;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonElement;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonNull;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonObject;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonPrimitive;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.TypeAdapter;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.LazilyParsedNumber;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.bind.JsonTreeReader;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.stream.JsonReader;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.stream.JsonToken;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.stream.JsonWriter;

class JsonElementTypeAdapter
extends TypeAdapter<JsonElement> {
    static final JsonElementTypeAdapter ADAPTER = new JsonElementTypeAdapter();

    private JsonElementTypeAdapter() {
    }

    private JsonElement tryBeginNesting(JsonReader jsonReader, JsonToken jsonToken) {
        switch (jsonToken) {
            case BEGIN_ARRAY: {
                jsonReader.beginArray();
                return new JsonArray();
            }
            case BEGIN_OBJECT: {
                jsonReader.beginObject();
                return new JsonObject();
            }
        }
        return null;
    }

    private JsonElement readTerminal(JsonReader object, JsonToken jsonToken) {
        switch (jsonToken) {
            case STRING: {
                return new JsonPrimitive(((JsonReader)object).nextString());
            }
            case NUMBER: {
                object = ((JsonReader)object).nextString();
                return new JsonPrimitive(new LazilyParsedNumber((String)object));
            }
            case BOOLEAN: {
                return new JsonPrimitive(((JsonReader)object).nextBoolean());
            }
            case NULL: {
                ((JsonReader)object).nextNull();
                return JsonNull.INSTANCE;
            }
        }
        throw new IllegalStateException("Unexpected token: " + (Object)((Object)jsonToken));
    }

    @Override
    public JsonElement read(JsonReader jsonReader) {
        if (jsonReader instanceof JsonTreeReader) {
            return ((JsonTreeReader)jsonReader).nextJsonElement();
        }
        JsonToken jsonToken = jsonReader.peek();
        JsonElement jsonElement = this.tryBeginNesting(jsonReader, jsonToken);
        if (jsonElement == null) {
            return this.readTerminal(jsonReader, jsonToken);
        }
        ArrayDeque<JsonElement> arrayDeque = new ArrayDeque<JsonElement>();
        while (true) {
            if (jsonReader.hasNext()) {
                JsonElement jsonElement2;
                boolean bl;
                String string = null;
                if (jsonElement instanceof JsonObject) {
                    string = jsonReader.nextName();
                }
                boolean bl2 = bl = (jsonElement2 = this.tryBeginNesting(jsonReader, jsonToken = jsonReader.peek())) != null;
                if (jsonElement2 == null) {
                    jsonElement2 = this.readTerminal(jsonReader, jsonToken);
                }
                if (jsonElement instanceof JsonArray) {
                    ((JsonArray)jsonElement).add(jsonElement2);
                } else {
                    ((JsonObject)jsonElement).add(string, jsonElement2);
                }
                if (!bl) continue;
                arrayDeque.addLast(jsonElement);
                jsonElement = jsonElement2;
                continue;
            }
            if (jsonElement instanceof JsonArray) {
                jsonReader.endArray();
            } else {
                jsonReader.endObject();
            }
            if (arrayDeque.isEmpty()) {
                return jsonElement;
            }
            jsonElement = (JsonElement)arrayDeque.removeLast();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void write(JsonWriter jsonWriter, JsonElement iterator2) {
        if (iterator2 == null || ((JsonElement)((Object)iterator2)).isJsonNull()) {
            jsonWriter.nullValue();
            return;
        }
        if (((JsonElement)((Object)iterator2)).isJsonPrimitive()) {
            if (((JsonPrimitive)((Object)(iterator2 = ((JsonElement)((Object)iterator2)).getAsJsonPrimitive()))).isNumber()) {
                jsonWriter.value(((JsonElement)((Object)iterator2)).getAsNumber());
                return;
            }
            if (((JsonPrimitive)((Object)iterator2)).isBoolean()) {
                jsonWriter.value(((JsonElement)((Object)iterator2)).getAsBoolean());
                return;
            }
            jsonWriter.value(((JsonElement)((Object)iterator2)).getAsString());
            return;
        }
        if (((JsonElement)((Object)iterator2)).isJsonArray()) {
            jsonWriter.beginArray();
            iterator2 = ((JsonElement)((Object)iterator2)).getAsJsonArray().iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    jsonWriter.endArray();
                    return;
                }
                JsonElement jsonElement = iterator2.next();
                this.write(jsonWriter, jsonElement);
            }
        }
        if (!((JsonElement)((Object)iterator2)).isJsonObject()) throw new IllegalArgumentException("Couldn't write " + iterator2.getClass());
        jsonWriter.beginObject();
        iterator2 = ((JsonElement)((Object)iterator2)).getAsJsonObject().entrySet().iterator();
        while (true) {
            if (!iterator2.hasNext()) {
                jsonWriter.endObject();
                return;
            }
            Map.Entry entry = (Map.Entry)iterator2.next();
            jsonWriter.name((String)entry.getKey());
            this.write(jsonWriter, (JsonElement)entry.getValue());
        }
    }
}

