/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.gson.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.GsonTypes;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.TroubleshootingGuide;

public class TypeToken<T> {
    private final Class<? super T> rawType;
    private final Type type;
    private final int hashCode;

    protected TypeToken() {
        this.type = this.getTypeTokenTypeArgument();
        this.rawType = GsonTypes.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    private TypeToken(Type type) {
        this.type = GsonTypes.canonicalize(Objects.requireNonNull(type));
        this.rawType = GsonTypes.getRawType(this.type);
        this.hashCode = this.type.hashCode();
    }

    private static boolean isCapturingTypeVariablesForbidden() {
        return !Objects.equals(System.getProperty("gson.allowCapturingTypeVariables"), "true");
    }

    private Type getTypeTokenTypeArgument() {
        Type type = this.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            if ((type = (ParameterizedType)type).getRawType() == TypeToken.class) {
                type = GsonTypes.canonicalize(type.getActualTypeArguments()[0]);
                if (TypeToken.isCapturingTypeVariablesForbidden()) {
                    TypeToken.verifyNoTypeVariable(type);
                }
                return type;
            }
        } else if (type == TypeToken.class) {
            throw new IllegalStateException("TypeToken must be created with a type argument: new TypeToken<...>() {}; When using code shrinkers (ProGuard, R8, ...) make sure that generic signatures are preserved.\nSee " + TroubleshootingGuide.createUrl("type-token-raw"));
        }
        throw new IllegalStateException("Must only create direct subclasses of TypeToken");
    }

    private static void verifyNoTypeVariable(Type type3) {
        if (type3 instanceof TypeVariable) {
            type3 = (TypeVariable)type3;
            throw new IllegalArgumentException("TypeToken type argument must not contain a type variable; captured type variable " + type3.getName() + " declared by " + type3.getGenericDeclaration() + "\nSee " + TroubleshootingGuide.createUrl("typetoken-type-variable"));
        }
        if (type3 instanceof GenericArrayType) {
            TypeToken.verifyNoTypeVariable(((GenericArrayType)type3).getGenericComponentType());
            return;
        }
        if (type3 instanceof ParameterizedType) {
            Type type2 = (type3 = (ParameterizedType)type3).getOwnerType();
            if (type2 != null) {
                TypeToken.verifyNoTypeVariable(type2);
            }
            for (Type type3 : type3.getActualTypeArguments()) {
                TypeToken.verifyNoTypeVariable(type3);
            }
            return;
        }
        if (type3 instanceof WildcardType) {
            type3 = (WildcardType)type3;
            for (Type type4 : type3.getLowerBounds()) {
                TypeToken.verifyNoTypeVariable(type4);
            }
            for (Type type4 : type3.getUpperBounds()) {
                TypeToken.verifyNoTypeVariable(type4);
            }
            return;
        }
        if (type3 == null) {
            throw new IllegalArgumentException("TypeToken captured `null` as type argument; probably a compiler / runtime bug");
        }
    }

    public final Class<? super T> getRawType() {
        return this.rawType;
    }

    public final Type getType() {
        return this.type;
    }

    @Deprecated
    public boolean isAssignableFrom(Class<?> clazz) {
        return this.isAssignableFrom((Type)clazz);
    }

    @Deprecated
    public boolean isAssignableFrom(Type type) {
        if (type == null) {
            return false;
        }
        if (this.type.equals(type)) {
            return true;
        }
        if (this.type instanceof Class) {
            return this.rawType.isAssignableFrom(GsonTypes.getRawType(type));
        }
        if (this.type instanceof ParameterizedType) {
            return TypeToken.isAssignableFrom(type, (ParameterizedType)this.type, new HashMap<String, Type>());
        }
        if (this.type instanceof GenericArrayType) {
            return this.rawType.isAssignableFrom(GsonTypes.getRawType(type)) && TypeToken.isAssignableFrom(type, (GenericArrayType)this.type);
        }
        throw TypeToken.buildUnsupportedTypeException(this.type, Class.class, ParameterizedType.class, GenericArrayType.class);
    }

    @Deprecated
    public boolean isAssignableFrom(TypeToken<?> typeToken) {
        return this.isAssignableFrom(typeToken.getType());
    }

    private static boolean isAssignableFrom(Type clazz, GenericArrayType type) {
        if ((type = type.getGenericComponentType()) instanceof ParameterizedType) {
            Class<?> clazz2 = clazz;
            if (clazz instanceof GenericArrayType) {
                clazz2 = ((GenericArrayType)((Object)clazz)).getGenericComponentType();
            } else if (clazz instanceof Class) {
                clazz = clazz;
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                clazz2 = clazz;
            }
            return TypeToken.isAssignableFrom(clazz2, (ParameterizedType)type, new HashMap<String, Type>());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isAssignableFrom(Type object, ParameterizedType parameterizedType, Map<String, Type> map) {
        void var0_1;
        while (var0_1 != null) {
            HashMap<String, Type> hashMap;
            Type type;
            int n;
            void var1_7;
            if (var1_7.equals(var0_1)) {
                return true;
            }
            Class<?> clazz = GsonTypes.getRawType((Type)var0_1);
            ParameterizedType parameterizedType2 = null;
            if (var0_1 instanceof ParameterizedType) {
                parameterizedType2 = (ParameterizedType)var0_1;
            }
            if (parameterizedType2 != null) {
                Type[] typeArray = parameterizedType2.getActualTypeArguments();
                TypeVariable<Class<?>>[] typeVariableArray = clazz.getTypeParameters();
                for (n = 0; n < typeArray.length; ++n) {
                    type = typeArray[n];
                    TypeVariable<Class<?>> typeVariable = typeVariableArray[n];
                    while (type instanceof TypeVariable) {
                        type = (TypeVariable)type;
                        type = (Type)hashMap.get(type.getName());
                    }
                    hashMap.put(typeVariable.getName(), type);
                }
                if (TypeToken.typeEquals(parameterizedType2, (ParameterizedType)var1_7, (Map<String, Type>)hashMap)) {
                    return true;
                }
            }
            Type[] typeArray = clazz.getGenericInterfaces();
            int n2 = typeArray.length;
            for (n = 0; n < n2; ++n) {
                type = typeArray[n];
                if (!TypeToken.isAssignableFrom(type, (ParameterizedType)var1_7, new HashMap<String, Type>(hashMap))) continue;
                return true;
            }
            Type type2 = clazz.getGenericSuperclass();
            hashMap = new HashMap<String, Type>(hashMap);
            Type type3 = type2;
        }
        return false;
    }

    private static boolean typeEquals(ParameterizedType typeArray, ParameterizedType typeArray2, Map<String, Type> map) {
        if (typeArray.getRawType().equals(typeArray2.getRawType())) {
            typeArray = typeArray.getActualTypeArguments();
            typeArray2 = typeArray2.getActualTypeArguments();
            for (int i = 0; i < typeArray.length; ++i) {
                if (TypeToken.matches(typeArray[i], typeArray2[i], map)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static IllegalArgumentException buildUnsupportedTypeException(Type type, Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder("Unsupported type, expected one of: ");
        for (Class<?> clazz : classArray) {
            stringBuilder.append(clazz.getName()).append(", ");
        }
        stringBuilder.append("but got: ").append(type.getClass().getName()).append(", for type token: ").append(type.toString());
        return new IllegalArgumentException(stringBuilder.toString());
    }

    private static boolean matches(Type type, Type type2, Map<String, Type> map) {
        return type2.equals(type) || type instanceof TypeVariable && type2.equals(map.get(((TypeVariable)type).getName()));
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final boolean equals(Object object) {
        return object instanceof TypeToken && GsonTypes.equals(this.type, ((TypeToken)object).type);
    }

    public final String toString() {
        return GsonTypes.typeToString(this.type);
    }

    public static TypeToken<?> get(Type type) {
        return new TypeToken(type);
    }

    public static <T> TypeToken<T> get(Class<T> clazz) {
        return new TypeToken<T>(clazz);
    }

    public static TypeToken<?> getParameterized(Type type, Type ... typeArray) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(typeArray);
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException("rawType must be of type Class, but was " + type);
        }
        int n = typeArray.length;
        Class clazz = (Class)type;
        TypeVariable<Class<T>>[] typeVariableArray = clazz.getTypeParameters();
        int n2 = typeVariableArray.length;
        if (n != n2) {
            throw new IllegalArgumentException(clazz.getName() + " requires " + n2 + " type arguments, but got " + n);
        }
        if (typeArray.length == 0) {
            return TypeToken.get(clazz);
        }
        if (GsonTypes.requiresOwnerType(type)) {
            throw new IllegalArgumentException("Raw type " + clazz.getName() + " is not supported because it requires specifying an owner type");
        }
        for (n = 0; n < n2; ++n) {
            Type type2 = Objects.requireNonNull(typeArray[n], "Type argument must not be null");
            Class<?> clazz2 = GsonTypes.getRawType(type2);
            TypeVariable typeVariable = typeVariableArray[n];
            for (Type type3 : typeVariable.getBounds()) {
                Class<?> clazz3 = GsonTypes.getRawType(type3);
                if (clazz3.isAssignableFrom(clazz2)) continue;
                throw new IllegalArgumentException("Type argument " + type2 + " does not satisfy bounds for type variable " + typeVariable + " declared by " + type);
            }
        }
        return new TypeToken(GsonTypes.newParameterizedTypeWithOwner(null, clazz, typeArray));
    }

    public static TypeToken<?> getArray(Type type) {
        return new TypeToken(GsonTypes.arrayOf(type));
    }
}

