/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.colosseum;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.logging.Logger;
import me.spartacus04.colosseum.ColosseumPlugin$Companion;
import me.spartacus04.colosseum.commandHandling.ColosseumCommandRegistrant;
import me.spartacus04.colosseum.i18n.ColosseumI18nManager;
import me.spartacus04.colosseum.i18n.ColosseumI18nManagerBuilder;
import me.spartacus04.colosseum.logging.MessageFormatter;
import me.spartacus04.colosseum.logging.PluginLogger;
import me.spartacus04.colosseum.scheduler.ColosseumScheduler;
import me.spartacus04.colosseum.scheduler.scheduling.TaskScheduler;
import me.spartacus04.colosseum.utils.version.MinecraftRevisions;
import me.spartacus04.colosseum.utils.version.MinecraftServerVersion;
import me.spartacus04.instantrestock.dependencies.instantrestock.annotations.NotNull;
import me.spartacus04.instantrestock.dependencies.instantrestock.annotations.Nullable;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.Gson;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.GsonBuilder;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.Strictness;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.Deprecated;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.Metadata;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.ReplaceWith;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.Unit;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.io.CloseableKt;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.io.TextStreamsKt;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.jvm.functions.Function1;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.jvm.internal.Intrinsics;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.text.Regex;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.text.StringsKt;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 72\u00020\u0001:\u00017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010&\u001a\u00020'H\u0017J\"\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u00052\u0012\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020)0,J!\u0010-\u001a\u0004\u0018\u00010\"2\u0017\u0010.\u001a\u0013\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020)0,\u00a2\u0006\u0002\b0J\u001f\u00101\u001a\u00020)2\u0017\u00102\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020)0,\u00a2\u0006\u0002\b0R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\"\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010!\u001a\u0004\u0018\u00010\"@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u00103\u001a\u0002048F\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u00a8\u00068"}, d2={"Lme/spartacus04/colosseum/ColosseumPlugin;", "Lorg/bukkit/plugin/java/JavaPlugin;", "<init>", "()V", "prefix", "", "Lme/spartacus04/instantrestock/dependencies/instantrestock/annotations/Nullable;", "isDebug", "", "scheduler", "Lme/spartacus04/colosseum/scheduler/scheduling/TaskScheduler;", "getScheduler", "()Lme/spartacus04/colosseum/scheduler/scheduling/TaskScheduler;", "colosseumLogger", "Lme/spartacus04/colosseum/logging/PluginLogger;", "getColosseumLogger", "()Lme/spartacus04/colosseum/logging/PluginLogger;", "messageFormatter", "Lme/spartacus04/colosseum/logging/MessageFormatter;", "getMessageFormatter", "()Lme/spartacus04/colosseum/logging/MessageFormatter;", "serverVersion", "Lme/spartacus04/colosseum/utils/version/MinecraftServerVersion;", "getServerVersion", "()Lme/spartacus04/colosseum/utils/version/MinecraftServerVersion;", "serverRevision", "Lme/spartacus04/colosseum/utils/version/MinecraftRevisions;", "getServerRevision", "()Lme/spartacus04/colosseum/utils/version/MinecraftRevisions;", "commandRegistrant", "Lme/spartacus04/colosseum/commandHandling/ColosseumCommandRegistrant;", "getCommandRegistrant", "()Lme/spartacus04/colosseum/commandHandling/ColosseumCommandRegistrant;", "value", "Lme/spartacus04/colosseum/i18n/ColosseumI18nManager;", "i18nManager", "getI18nManager", "()Lme/spartacus04/colosseum/i18n/ColosseumI18nManager;", "getLogger", "Ljava/util/logging/Logger;", "checkForUpdates", "", "repo", "consumer", "Lme/spartacus04/instantrestock/dependencies/instantrestock/kotlin/Function1;", "buildI18nManager", "builderAction", "Lme/spartacus04/colosseum/i18n/ColosseumI18nManagerBuilder;", "Lme/spartacus04/instantrestock/dependencies/instantrestock/kotlin/ExtensionFunctionType;", "registerCommands", "commandsAction", "gson", "Lme/spartacus04/instantrestock/dependencies/instantrestock/gson/Gson;", "getGson", "()Lme/spartacus04/instantrestock/dependencies/instantrestock/gson/Gson;", "Companion", "Colosseum"})
public abstract class ColosseumPlugin
extends JavaPlugin {
    @NotNull
    public static final ColosseumPlugin$Companion Companion = new ColosseumPlugin$Companion(null);
    @NotNull
    private final String prefix;
    private final boolean isDebug;
    @NotNull
    private final TaskScheduler scheduler;
    @NotNull
    private final PluginLogger colosseumLogger;
    @NotNull
    private final MessageFormatter messageFormatter;
    @NotNull
    private final MinecraftServerVersion serverVersion;
    @NotNull
    private final MinecraftRevisions serverRevision;
    @NotNull
    private final ColosseumCommandRegistrant commandRegistrant;
    @Nullable
    private ColosseumI18nManager i18nManager;
    @NotNull
    private static final Gson GSON;

    public ColosseumPlugin() {
        String string = this.getDescription().getPrefix();
        if (string == null) {
            String string2 = this.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
        }
        this.prefix = string;
        String string3 = this.getDescription().getVersion();
        Intrinsics.checkNotNullExpressionValue(string3, "getVersion(...)");
        this.isDebug = StringsKt.contains$default((CharSequence)string3, "dev", false, 2, null);
        this.scheduler = ColosseumScheduler.INSTANCE.getScheduler((Plugin)this);
        this.colosseumLogger = new PluginLogger(this.isDebug, this.prefix);
        this.messageFormatter = new MessageFormatter(this.prefix);
        this.serverVersion = new MinecraftServerVersion((Plugin)this);
        this.serverRevision = this.serverVersion.getRevision();
        this.commandRegistrant = new ColosseumCommandRegistrant(this);
    }

    @NotNull
    public final TaskScheduler getScheduler() {
        return this.scheduler;
    }

    @NotNull
    public final PluginLogger getColosseumLogger() {
        return this.colosseumLogger;
    }

    @NotNull
    public final MessageFormatter getMessageFormatter() {
        return this.messageFormatter;
    }

    @NotNull
    public final MinecraftServerVersion getServerVersion() {
        return this.serverVersion;
    }

    @NotNull
    public final MinecraftRevisions getServerRevision() {
        return this.serverRevision;
    }

    @NotNull
    public final ColosseumCommandRegistrant getCommandRegistrant() {
        return this.commandRegistrant;
    }

    @Nullable
    public final ColosseumI18nManager getI18nManager() {
        return this.i18nManager;
    }

    @Deprecated(message="Use `colosseumLogger` instead", replaceWith=@ReplaceWith(expression="colosseumLogger", imports={}))
    @NotNull
    public Logger getLogger() {
        Logger logger = super.getLogger();
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        return logger;
    }

    public final void checkForUpdates(@NotNull String string, @NotNull Function1<? super String, Unit> function1) {
        Intrinsics.checkNotNullParameter(string, "repo");
        Intrinsics.checkNotNullParameter(function1, "consumer");
        this.scheduler.runTaskAsynchronously(() -> ColosseumPlugin.checkForUpdates$lambda$0(string, this, function1));
    }

    @Nullable
    public final ColosseumI18nManager buildI18nManager(@NotNull Function1<? super ColosseumI18nManagerBuilder, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "builderAction");
        if (this.i18nManager != null) {
            return this.i18nManager;
        }
        ColosseumI18nManagerBuilder colosseumI18nManagerBuilder = new ColosseumI18nManagerBuilder(this);
        function1.invoke(colosseumI18nManagerBuilder);
        this.i18nManager = colosseumI18nManagerBuilder.build();
        return this.i18nManager;
    }

    public final void registerCommands(@NotNull Function1<? super ColosseumCommandRegistrant, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "commandsAction");
        function1.invoke(this.commandRegistrant);
        this.commandRegistrant.register();
    }

    @NotNull
    public final Gson getGson() {
        return GSON;
    }

    private static final void checkForUpdates$lambda$0(String object, ColosseumPlugin colosseumPlugin, Function1 object2) {
        try {
            Object object3;
            object = new BufferedReader(new InputStreamReader(new URI("https://api.github.com/repos/" + (String)object + "/releases/latest").toURL().openStream()));
            object = (Closeable)object;
            Throwable throwable = null;
            try {
                object3 = (BufferedReader)object;
                object3 = TextStreamsKt.readText((Reader)object3);
            }
            catch (Throwable throwable2) {
                try {
                    object2 = throwable2;
                    throwable = throwable2;
                    throw object2;
                }
                catch (Throwable throwable3) {
                    CloseableKt.closeFinally((Closeable)object, throwable);
                    throw throwable3;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            object = object3;
            Object object4 = Regex.find$default(new Regex("\"tag_name\": ?\"([^\"]+)\""), (CharSequence)object, 0, 2, null);
            String string = object4 != null && (object4 = object4.getGroupValues()) != null ? (String)object4.get(1) : null;
            Intrinsics.checkNotNull(string);
            object = string;
            colosseumPlugin.colosseumLogger.debug("Latest version: " + (String)object);
            object2.invoke(object);
            return;
        }
        catch (IOException iOException) {
            colosseumPlugin.colosseumLogger.warn("Unable to check for updates: " + iOException.getMessage());
            return;
        }
    }

    public static final /* synthetic */ Gson access$getGSON$cp() {
        return GSON;
    }

    static {
        Gson gson = new GsonBuilder().setStrictness(Strictness.LENIENT).setPrettyPrinting().create();
        Intrinsics.checkNotNullExpressionValue(gson, "create(...)");
        GSON = gson;
    }
}

