/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.bstats;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import me.spartacus04.instantrestock.dependencies.instantrestock.bstats.charts.CustomChart;
import me.spartacus04.instantrestock.dependencies.instantrestock.bstats.json.JsonObjectBuilder;
import me.spartacus04.instantrestock.dependencies.instantrestock.bstats.json.JsonObjectBuilder$JsonObject;

public class MetricsBase {
    public static final String METRICS_VERSION = "3.1.0";
    private static final String REPORT_URL = "https://bStats.org/api/v2/data/%s";
    private final ScheduledExecutorService scheduler;
    private final String platform;
    private final String serverUuid;
    private final int serviceId;
    private final Consumer<JsonObjectBuilder> appendPlatformDataConsumer;
    private final Consumer<JsonObjectBuilder> appendServiceDataConsumer;
    private final Consumer<Runnable> submitTaskConsumer;
    private final Supplier<Boolean> checkServiceEnabledSupplier;
    private final BiConsumer<String, Throwable> errorLogger;
    private final Consumer<String> infoLogger;
    private final boolean logErrors;
    private final boolean logSentData;
    private final boolean logResponseStatusText;
    private final Set<CustomChart> customCharts = new HashSet<CustomChart>();
    private final boolean enabled;

    public MetricsBase(String string, String string2, int n, boolean bl, Consumer<JsonObjectBuilder> consumer, Consumer<JsonObjectBuilder> consumer2, Consumer<Runnable> consumer3, Supplier<Boolean> supplier, BiConsumer<String, Throwable> biConsumer, Consumer<String> consumer4, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, runnable -> {
            runnable = new Thread(runnable, "bStats-Metrics");
            ((Thread)runnable).setDaemon(true);
            return runnable;
        });
        scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler = scheduledThreadPoolExecutor;
        this.platform = string;
        this.serverUuid = string2;
        this.serviceId = n;
        this.enabled = bl;
        this.appendPlatformDataConsumer = consumer;
        this.appendServiceDataConsumer = consumer2;
        this.submitTaskConsumer = consumer3;
        this.checkServiceEnabledSupplier = supplier;
        this.errorLogger = biConsumer;
        this.infoLogger = consumer4;
        this.logErrors = bl2;
        this.logSentData = bl3;
        this.logResponseStatusText = bl4;
        if (!bl5) {
            this.checkRelocation();
        }
        if (bl) {
            this.startSubmitting();
        }
    }

    public void addCustomChart(CustomChart customChart) {
        this.customCharts.add(customChart);
    }

    public void shutdown() {
        this.scheduler.shutdown();
    }

    private void startSubmitting() {
        Runnable runnable = () -> {
            if (!this.enabled || !this.checkServiceEnabledSupplier.get().booleanValue()) {
                this.scheduler.shutdown();
                return;
            }
            if (this.submitTaskConsumer != null) {
                this.submitTaskConsumer.accept(this::submitData);
                return;
            }
            this.submitData();
        };
        long l = (long)(60000.0 * (3.0 + Math.random() * 3.0));
        long l2 = (long)(60000.0 * (Math.random() * 30.0));
        this.scheduler.schedule(runnable, l, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleAtFixedRate(runnable, l + l2, 1800000L, TimeUnit.MILLISECONDS);
    }

    private void submitData() {
        Object object = new JsonObjectBuilder();
        this.appendPlatformDataConsumer.accept((JsonObjectBuilder)object);
        JsonObjectBuilder jsonObjectBuilder = new JsonObjectBuilder();
        this.appendServiceDataConsumer.accept(jsonObjectBuilder);
        JsonObjectBuilder$JsonObject[] jsonObjectBuilder$JsonObjectArray = (JsonObjectBuilder$JsonObject[])this.customCharts.stream().map(customChart -> customChart.getRequestJsonObject(this.errorLogger, this.logErrors)).filter(Objects::nonNull).toArray(JsonObjectBuilder$JsonObject[]::new);
        jsonObjectBuilder.appendField("id", this.serviceId);
        jsonObjectBuilder.appendField("customCharts", jsonObjectBuilder$JsonObjectArray);
        ((JsonObjectBuilder)object).appendField("service", jsonObjectBuilder.build());
        ((JsonObjectBuilder)object).appendField("serverUUID", this.serverUuid);
        ((JsonObjectBuilder)object).appendField("metricsVersion", METRICS_VERSION);
        object = ((JsonObjectBuilder)object).build();
        this.scheduler.execute(() -> this.lambda$submitData$4((JsonObjectBuilder$JsonObject)object));
    }

    private void sendData(JsonObjectBuilder$JsonObject object) {
        if (this.logSentData) {
            this.infoLogger.accept("Sent bStats metrics data: " + ((JsonObjectBuilder$JsonObject)object).toString());
        }
        Object object2 = String.format(REPORT_URL, this.platform);
        object2 = (HttpsURLConnection)new URL((String)object2).openConnection();
        object = MetricsBase.compress(((JsonObjectBuilder$JsonObject)object).toString());
        ((HttpURLConnection)object2).setRequestMethod("POST");
        ((URLConnection)object2).addRequestProperty("Accept", "application/json");
        ((URLConnection)object2).addRequestProperty("Connection", "close");
        ((URLConnection)object2).addRequestProperty("Content-Encoding", "gzip");
        ((URLConnection)object2).addRequestProperty("Content-Length", String.valueOf(((Object)object).length));
        ((URLConnection)object2).setRequestProperty("Content-Type", "application/json");
        ((URLConnection)object2).setRequestProperty("User-Agent", "Metrics-Service/1");
        ((URLConnection)object2).setDoOutput(true);
        try (Object object3 = new DataOutputStream(((URLConnection)object2).getOutputStream());){
            ((FilterOutputStream)object3).write((byte[])object);
        }
        object3 = new StringBuilder();
        object = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
        try {
            while ((object2 = ((BufferedReader)object).readLine()) != null) {
                ((StringBuilder)object3).append((String)object2);
            }
        }
        finally {
            ((BufferedReader)object).close();
        }
        if (this.logResponseStatusText) {
            this.infoLogger.accept("Sent data to bStats and received response: " + object3);
        }
    }

    private void checkRelocation() {
        if (System.getProperty("bstats.relocatecheck") == null || !System.getProperty("bstats.relocatecheck").equals("false")) {
            String string = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115});
            String string2 = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
            if (MetricsBase.class.getPackage().getName().startsWith(string) || MetricsBase.class.getPackage().getName().startsWith(string2)) {
                throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
            }
        }
    }

    private static byte[] compress(String string) {
        if (string == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);){
            gZIPOutputStream.write(string.getBytes(StandardCharsets.UTF_8));
        }
        return byteArrayOutputStream.toByteArray();
    }

    private /* synthetic */ void lambda$submitData$4(JsonObjectBuilder$JsonObject jsonObject) {
        try {
            this.sendData(jsonObject);
            return;
        }
        catch (Exception exception) {
            if (this.logErrors) {
                this.errorLogger.accept("Could not submit bStats metrics data", exception);
            }
            return;
        }
    }
}

