/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.gson;

import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.spartacus04.instantrestock.dependencies.instantrestock.errorprone.annotations.CanIgnoreReturnValue;
import me.spartacus04.instantrestock.dependencies.instantrestock.errorprone.annotations.InlineMe;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.ExclusionStrategy;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.FieldNamingPolicy;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.FieldNamingStrategy;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.FormattingStyle;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.Gson;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.InstanceCreator;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonDeserializer;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonSerializer;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.LongSerializationPolicy;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.ReflectionAccessFilter;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.Strictness;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.ToNumberStrategy;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.TypeAdapter;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.TypeAdapterFactory;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.Excluder;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.bind.DefaultDateTypeAdapter$DateType;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.bind.TreeTypeAdapter;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.bind.TypeAdapters;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.sql.SqlTypesSupport;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.reflect.TypeToken;

public final class GsonBuilder {
    private Excluder excluder = Excluder.DEFAULT;
    private LongSerializationPolicy longSerializationPolicy = LongSerializationPolicy.DEFAULT;
    private FieldNamingStrategy fieldNamingPolicy = FieldNamingPolicy.IDENTITY;
    private final Map<Type, InstanceCreator<?>> instanceCreators = new HashMap();
    private final List<TypeAdapterFactory> factories = new ArrayList<TypeAdapterFactory>();
    private final List<TypeAdapterFactory> hierarchyFactories = new ArrayList<TypeAdapterFactory>();
    private boolean serializeNulls = false;
    private String datePattern = Gson.DEFAULT_DATE_PATTERN;
    private int dateStyle = 2;
    private int timeStyle = 2;
    private boolean complexMapKeySerialization = false;
    private boolean serializeSpecialFloatingPointValues = false;
    private boolean escapeHtmlChars = true;
    private FormattingStyle formattingStyle = Gson.DEFAULT_FORMATTING_STYLE;
    private boolean generateNonExecutableJson = false;
    private Strictness strictness = Gson.DEFAULT_STRICTNESS;
    private boolean useJdkUnsafe = true;
    private ToNumberStrategy objectToNumberStrategy = Gson.DEFAULT_OBJECT_TO_NUMBER_STRATEGY;
    private ToNumberStrategy numberToNumberStrategy = Gson.DEFAULT_NUMBER_TO_NUMBER_STRATEGY;
    private final ArrayDeque<ReflectionAccessFilter> reflectionFilters = new ArrayDeque();

    public GsonBuilder() {
    }

    GsonBuilder(Gson gson) {
        this.excluder = gson.excluder;
        this.fieldNamingPolicy = gson.fieldNamingStrategy;
        this.instanceCreators.putAll(gson.instanceCreators);
        this.serializeNulls = gson.serializeNulls;
        this.complexMapKeySerialization = gson.complexMapKeySerialization;
        this.generateNonExecutableJson = gson.generateNonExecutableJson;
        this.escapeHtmlChars = gson.htmlSafe;
        this.formattingStyle = gson.formattingStyle;
        this.strictness = gson.strictness;
        this.serializeSpecialFloatingPointValues = gson.serializeSpecialFloatingPointValues;
        this.longSerializationPolicy = gson.longSerializationPolicy;
        this.datePattern = gson.datePattern;
        this.dateStyle = gson.dateStyle;
        this.timeStyle = gson.timeStyle;
        this.factories.addAll(gson.builderFactories);
        this.hierarchyFactories.addAll(gson.builderHierarchyFactories);
        this.useJdkUnsafe = gson.useJdkUnsafe;
        this.objectToNumberStrategy = gson.objectToNumberStrategy;
        this.numberToNumberStrategy = gson.numberToNumberStrategy;
        this.reflectionFilters.addAll(gson.reflectionFilters);
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setVersion(double d) {
        if (Double.isNaN(d) || d < 0.0) {
            throw new IllegalArgumentException("Invalid version: " + d);
        }
        this.excluder = this.excluder.withVersion(d);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder excludeFieldsWithModifiers(int ... nArray) {
        Objects.requireNonNull(nArray);
        this.excluder = this.excluder.withModifiers(nArray);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder generateNonExecutableJson() {
        this.generateNonExecutableJson = true;
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder excludeFieldsWithoutExposeAnnotation() {
        this.excluder = this.excluder.excludeFieldsWithoutExposeAnnotation();
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder serializeNulls() {
        this.serializeNulls = true;
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder enableComplexMapKeySerialization() {
        this.complexMapKeySerialization = true;
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder disableInnerClassSerialization() {
        this.excluder = this.excluder.disableInnerClassSerialization();
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setLongSerializationPolicy(LongSerializationPolicy longSerializationPolicy) {
        this.longSerializationPolicy = Objects.requireNonNull(longSerializationPolicy);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setFieldNamingPolicy(FieldNamingPolicy fieldNamingPolicy) {
        return this.setFieldNamingStrategy(fieldNamingPolicy);
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setFieldNamingStrategy(FieldNamingStrategy fieldNamingStrategy) {
        this.fieldNamingPolicy = Objects.requireNonNull(fieldNamingStrategy);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setObjectToNumberStrategy(ToNumberStrategy toNumberStrategy) {
        this.objectToNumberStrategy = Objects.requireNonNull(toNumberStrategy);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setNumberToNumberStrategy(ToNumberStrategy toNumberStrategy) {
        this.numberToNumberStrategy = Objects.requireNonNull(toNumberStrategy);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setExclusionStrategies(ExclusionStrategy ... exclusionStrategyArray) {
        Objects.requireNonNull(exclusionStrategyArray);
        for (ExclusionStrategy exclusionStrategy : exclusionStrategyArray) {
            this.excluder = this.excluder.withExclusionStrategy(exclusionStrategy, true, true);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder addSerializationExclusionStrategy(ExclusionStrategy exclusionStrategy) {
        Objects.requireNonNull(exclusionStrategy);
        this.excluder = this.excluder.withExclusionStrategy(exclusionStrategy, true, false);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder addDeserializationExclusionStrategy(ExclusionStrategy exclusionStrategy) {
        Objects.requireNonNull(exclusionStrategy);
        this.excluder = this.excluder.withExclusionStrategy(exclusionStrategy, false, true);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setPrettyPrinting() {
        return this.setFormattingStyle(FormattingStyle.PRETTY);
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setFormattingStyle(FormattingStyle formattingStyle) {
        this.formattingStyle = Objects.requireNonNull(formattingStyle);
        return this;
    }

    @Deprecated
    @InlineMe(replacement="this.setStrictness(Strictness.LENIENT)", imports={"me.spartacus04.instantrestock.dependencies.instantrestock.gson.Strictness"})
    @CanIgnoreReturnValue
    public final GsonBuilder setLenient() {
        return this.setStrictness(Strictness.LENIENT);
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setStrictness(Strictness strictness) {
        this.strictness = Objects.requireNonNull(strictness);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder disableHtmlEscaping() {
        this.escapeHtmlChars = false;
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setDateFormat(String string) {
        if (string != null) {
            try {
                new SimpleDateFormat(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("The date pattern '" + string + "' is not valid", illegalArgumentException);
            }
        }
        this.datePattern = string;
        return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public final GsonBuilder setDateFormat(int n) {
        this.dateStyle = GsonBuilder.checkDateFormatStyle(n);
        this.datePattern = null;
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder setDateFormat(int n, int n2) {
        this.dateStyle = GsonBuilder.checkDateFormatStyle(n);
        this.timeStyle = GsonBuilder.checkDateFormatStyle(n2);
        this.datePattern = null;
        return this;
    }

    private static int checkDateFormatStyle(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Invalid style: " + n);
        }
        return n;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder registerTypeAdapter(Type type, Object object) {
        Object object2;
        Objects.requireNonNull(type);
        Objects.requireNonNull(object);
        if (!(object instanceof JsonSerializer || object instanceof JsonDeserializer || object instanceof InstanceCreator || object instanceof TypeAdapter)) {
            throw new IllegalArgumentException("Class " + object.getClass().getName() + " does not implement any supported type adapter class or interface");
        }
        if (GsonBuilder.hasNonOverridableAdapter(type)) {
            throw new IllegalArgumentException("Cannot override built-in adapter for " + type);
        }
        if (object instanceof InstanceCreator) {
            this.instanceCreators.put(type, (InstanceCreator)object);
        }
        if (object instanceof JsonSerializer || object instanceof JsonDeserializer) {
            object2 = TypeToken.get(type);
            this.factories.add(TreeTypeAdapter.newFactoryWithMatchRawType(object2, object));
        }
        if (object instanceof TypeAdapter) {
            object2 = TypeAdapters.newFactory(TypeToken.get(type), (TypeAdapter)object);
            this.factories.add((TypeAdapterFactory)object2);
        }
        return this;
    }

    private static boolean hasNonOverridableAdapter(Type type) {
        return type == Object.class;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder registerTypeAdapterFactory(TypeAdapterFactory typeAdapterFactory) {
        Objects.requireNonNull(typeAdapterFactory);
        this.factories.add(typeAdapterFactory);
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder registerTypeHierarchyAdapter(Class<?> object, Object object2) {
        Objects.requireNonNull(object);
        Objects.requireNonNull(object2);
        if (!(object2 instanceof JsonSerializer || object2 instanceof JsonDeserializer || object2 instanceof TypeAdapter)) {
            throw new IllegalArgumentException("Class " + object2.getClass().getName() + " does not implement any supported type adapter class or interface");
        }
        if (object2 instanceof JsonDeserializer || object2 instanceof JsonSerializer) {
            this.hierarchyFactories.add(TreeTypeAdapter.newTypeHierarchyFactory(object, object2));
        }
        if (object2 instanceof TypeAdapter) {
            object = TypeAdapters.newTypeHierarchyFactory(object, (TypeAdapter)object2);
            this.factories.add((TypeAdapterFactory)object);
        }
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder serializeSpecialFloatingPointValues() {
        this.serializeSpecialFloatingPointValues = true;
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder disableJdkUnsafe() {
        this.useJdkUnsafe = false;
        return this;
    }

    @CanIgnoreReturnValue
    public final GsonBuilder addReflectionAccessFilter(ReflectionAccessFilter reflectionAccessFilter) {
        Objects.requireNonNull(reflectionAccessFilter);
        this.reflectionFilters.addFirst(reflectionAccessFilter);
        return this;
    }

    public final Gson create() {
        ArrayList<TypeAdapterFactory> arrayList = new ArrayList<TypeAdapterFactory>(this.factories.size() + this.hierarchyFactories.size() + 3);
        arrayList.addAll(this.factories);
        Collections.reverse(arrayList);
        ArrayList<TypeAdapterFactory> arrayList2 = new ArrayList<TypeAdapterFactory>(this.hierarchyFactories);
        Collections.reverse(arrayList2);
        arrayList.addAll(arrayList2);
        GsonBuilder.addTypeAdaptersForDate(this.datePattern, this.dateStyle, this.timeStyle, arrayList);
        return new Gson(this.excluder, this.fieldNamingPolicy, new HashMap(this.instanceCreators), this.serializeNulls, this.complexMapKeySerialization, this.generateNonExecutableJson, this.escapeHtmlChars, this.formattingStyle, this.strictness, this.serializeSpecialFloatingPointValues, this.useJdkUnsafe, this.longSerializationPolicy, this.datePattern, this.dateStyle, this.timeStyle, new ArrayList<TypeAdapterFactory>(this.factories), new ArrayList<TypeAdapterFactory>(this.hierarchyFactories), arrayList, this.objectToNumberStrategy, this.numberToNumberStrategy, new ArrayList<ReflectionAccessFilter>(this.reflectionFilters));
    }

    private static void addTypeAdaptersForDate(String string, int n, int n2, List<TypeAdapterFactory> list) {
        TypeAdapterFactory typeAdapterFactory;
        boolean bl = SqlTypesSupport.SUPPORTS_SQL_TYPES;
        TypeAdapterFactory typeAdapterFactory2 = null;
        TypeAdapterFactory typeAdapterFactory3 = null;
        if (string != null && !string.trim().isEmpty()) {
            typeAdapterFactory = DefaultDateTypeAdapter$DateType.DATE.createAdapterFactory(string);
            if (bl) {
                typeAdapterFactory2 = SqlTypesSupport.TIMESTAMP_DATE_TYPE.createAdapterFactory(string);
                typeAdapterFactory3 = SqlTypesSupport.DATE_DATE_TYPE.createAdapterFactory(string);
            }
        } else if (n != 2 || n2 != 2) {
            typeAdapterFactory = DefaultDateTypeAdapter$DateType.DATE.createAdapterFactory(n, n2);
            if (bl) {
                typeAdapterFactory2 = SqlTypesSupport.TIMESTAMP_DATE_TYPE.createAdapterFactory(n, n2);
                typeAdapterFactory3 = SqlTypesSupport.DATE_DATE_TYPE.createAdapterFactory(n, n2);
            }
        } else {
            return;
        }
        list.add(typeAdapterFactory);
        if (bl) {
            list.add(typeAdapterFactory2);
            list.add(typeAdapterFactory3);
        }
    }
}

