/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.GsonTypes;

final class GsonTypes$ParameterizedTypeImpl
implements Serializable,
ParameterizedType {
    private final Type ownerType;
    private final Type rawType;
    private final Type[] typeArguments;
    private static final long serialVersionUID = 0L;

    GsonTypes$ParameterizedTypeImpl(Type type, Class<?> clazz, Type ... typeArray) {
        Objects.requireNonNull(clazz);
        if (type == null && GsonTypes.requiresOwnerType(clazz)) {
            throw new IllegalArgumentException("Must specify owner type for " + clazz);
        }
        this.ownerType = type == null ? null : GsonTypes.canonicalize(type);
        this.rawType = GsonTypes.canonicalize(clazz);
        this.typeArguments = (Type[])typeArray.clone();
        int n = this.typeArguments.length;
        for (int i = 0; i < n; ++i) {
            Objects.requireNonNull(this.typeArguments[i]);
            GsonTypes.checkNotPrimitive(this.typeArguments[i]);
            this.typeArguments[i] = GsonTypes.canonicalize(this.typeArguments[i]);
        }
    }

    @Override
    public final Type[] getActualTypeArguments() {
        return (Type[])this.typeArguments.clone();
    }

    @Override
    public final Type getRawType() {
        return this.rawType;
    }

    @Override
    public final Type getOwnerType() {
        return this.ownerType;
    }

    public final boolean equals(Object object) {
        return object instanceof ParameterizedType && GsonTypes.equals(this, (ParameterizedType)object);
    }

    private static int hashCodeOrZero(Object object) {
        if (object != null) {
            return object.hashCode();
        }
        return 0;
    }

    public final int hashCode() {
        return Arrays.hashCode(this.typeArguments) ^ this.rawType.hashCode() ^ GsonTypes$ParameterizedTypeImpl.hashCodeOrZero(this.ownerType);
    }

    public final String toString() {
        int n = this.typeArguments.length;
        if (n == 0) {
            return GsonTypes.typeToString(this.rawType);
        }
        StringBuilder stringBuilder = new StringBuilder(30 * (n + 1));
        stringBuilder.append(GsonTypes.typeToString(this.rawType)).append("<").append(GsonTypes.typeToString(this.typeArguments[0]));
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(", ").append(GsonTypes.typeToString(this.typeArguments[i]));
        }
        return stringBuilder.append(">").toString();
    }
}

