/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.bind;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import me.spartacus04.instantrestock.dependencies.instantrestock.errorprone.annotations.CanIgnoreReturnValue;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonArray;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonElement;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonNull;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonObject;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonPrimitive;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.bind.JsonTreeWriter$1;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.stream.JsonWriter;

public final class JsonTreeWriter
extends JsonWriter {
    private static final Writer UNWRITABLE_WRITER = new JsonTreeWriter$1();
    private static final JsonPrimitive SENTINEL_CLOSED = new JsonPrimitive("closed");
    private final List<JsonElement> stack = new ArrayList<JsonElement>();
    private String pendingName;
    private JsonElement product = JsonNull.INSTANCE;

    public JsonTreeWriter() {
        super(UNWRITABLE_WRITER);
    }

    public final JsonElement get() {
        if (!this.stack.isEmpty()) {
            throw new IllegalStateException("Expected one JSON element but was " + this.stack);
        }
        return this.product;
    }

    private JsonElement peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private void put(JsonElement jsonElement) {
        if (this.pendingName != null) {
            if (!jsonElement.isJsonNull() || this.getSerializeNulls()) {
                JsonObject jsonObject = (JsonObject)this.peek();
                jsonObject.add(this.pendingName, jsonElement);
            }
            this.pendingName = null;
            return;
        }
        if (this.stack.isEmpty()) {
            this.product = jsonElement;
            return;
        }
        JsonElement jsonElement2 = this.peek();
        if (jsonElement2 instanceof JsonArray) {
            ((JsonArray)jsonElement2).add(jsonElement);
            return;
        }
        throw new IllegalStateException();
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter beginArray() {
        JsonArray jsonArray = new JsonArray();
        this.put(jsonArray);
        this.stack.add(jsonArray);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter endArray() {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement jsonElement = this.peek();
        if (jsonElement instanceof JsonArray) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter beginObject() {
        JsonObject jsonObject = new JsonObject();
        this.put(jsonObject);
        this.stack.add(jsonObject);
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter endObject() {
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException();
        }
        JsonElement jsonElement = this.peek();
        if (jsonElement instanceof JsonObject) {
            this.stack.remove(this.stack.size() - 1);
            return this;
        }
        throw new IllegalStateException();
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter name(String string) {
        Objects.requireNonNull(string, "name == null");
        if (this.stack.isEmpty() || this.pendingName != null) {
            throw new IllegalStateException("Did not expect a name");
        }
        JsonElement jsonElement = this.peek();
        if (jsonElement instanceof JsonObject) {
            this.pendingName = string;
            return this;
        }
        throw new IllegalStateException("Please begin an object before writing a name.");
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter value(String string) {
        if (string == null) {
            return ((JsonWriter)this).nullValue();
        }
        this.put(new JsonPrimitive(string));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter value(boolean bl) {
        this.put(new JsonPrimitive(bl));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter value(Boolean bl) {
        if (bl == null) {
            return ((JsonWriter)this).nullValue();
        }
        this.put(new JsonPrimitive(bl));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter value(float f) {
        if (!this.isLenient() && (Float.isNaN(f) || Float.isInfinite(f))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + f);
        }
        this.put(new JsonPrimitive(Float.valueOf(f)));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter value(double d) {
        if (!this.isLenient() && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + d);
        }
        this.put(new JsonPrimitive(d));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter value(long l) {
        this.put(new JsonPrimitive(l));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter value(Number number) {
        double d;
        if (number == null) {
            return ((JsonWriter)this).nullValue();
        }
        if (!this.isLenient() && (Double.isNaN(d = number.doubleValue()) || Double.isInfinite(d))) {
            throw new IllegalArgumentException("JSON forbids NaN and infinities: " + number);
        }
        this.put(new JsonPrimitive(number));
        return this;
    }

    @Override
    @CanIgnoreReturnValue
    public final JsonWriter nullValue() {
        this.put(JsonNull.INSTANCE);
        return this;
    }

    @Override
    public final JsonWriter jsonValue(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void flush() {
    }

    @Override
    public final void close() {
        if (!this.stack.isEmpty()) {
            throw new IOException("Incomplete document");
        }
        this.stack.add(SENTINEL_CLOSED);
    }
}

