/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.bind;

import java.util.ArrayList;
import java.util.Map;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonElement;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonPrimitive;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonSyntaxException;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.TypeAdapter;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.JsonReaderInternalAccess;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.ObjectConstructor;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.Streams;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.bind.MapTypeAdapterFactory;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.stream.JsonReader;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.stream.JsonToken;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.stream.JsonWriter;

final class MapTypeAdapterFactory$Adapter<K, V>
extends TypeAdapter<Map<K, V>> {
    private final TypeAdapter<K> keyTypeAdapter;
    private final TypeAdapter<V> valueTypeAdapter;
    private final ObjectConstructor<? extends Map<K, V>> constructor;
    final /* synthetic */ MapTypeAdapterFactory this$0;

    MapTypeAdapterFactory$Adapter(MapTypeAdapterFactory mapTypeAdapterFactory, TypeAdapter<K> typeAdapter, TypeAdapter<V> typeAdapter2, ObjectConstructor<? extends Map<K, V>> objectConstructor) {
        this.this$0 = mapTypeAdapterFactory;
        this.keyTypeAdapter = typeAdapter;
        this.valueTypeAdapter = typeAdapter2;
        this.constructor = objectConstructor;
    }

    @Override
    public final Map<K, V> read(JsonReader jsonReader) {
        JsonToken jsonToken = jsonReader.peek();
        if (jsonToken == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        Map<JsonToken, V> map = this.constructor.construct();
        if (jsonToken == JsonToken.BEGIN_ARRAY) {
            jsonReader.beginArray();
            while (jsonReader.hasNext()) {
                jsonReader.beginArray();
                jsonToken = this.keyTypeAdapter.read(jsonReader);
                V v = this.valueTypeAdapter.read(jsonReader);
                v = map.put(jsonToken, v);
                if (v != null) {
                    throw new JsonSyntaxException("duplicate key: " + (Object)((Object)jsonToken));
                }
                jsonReader.endArray();
            }
            jsonReader.endArray();
        } else {
            jsonReader.beginObject();
            while (jsonReader.hasNext()) {
                JsonReaderInternalAccess.INSTANCE.promoteNameToValue(jsonReader);
                jsonToken = this.keyTypeAdapter.read(jsonReader);
                V v = this.valueTypeAdapter.read(jsonReader);
                if ((v = map.put(jsonToken, v)) == null) continue;
                throw new JsonSyntaxException("duplicate key: " + (Object)((Object)jsonToken));
            }
            jsonReader.endObject();
        }
        return map;
    }

    @Override
    public final void write(JsonWriter jsonWriter, Map<K, V> object) {
        JsonElement jsonElement;
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        if (!this.this$0.complexMapKeySerialization) {
            jsonWriter.beginObject();
            for (Map.Entry entry : object.entrySet()) {
                jsonWriter.name(String.valueOf(entry.getKey()));
                this.valueTypeAdapter.write(jsonWriter, entry.getValue());
            }
            jsonWriter.endObject();
            return;
        }
        boolean bl = false;
        ArrayList<JsonElement> arrayList = new ArrayList<JsonElement>(object.size());
        ArrayList arrayList2 = new ArrayList(object.size());
        for (Map.Entry entry : object.entrySet()) {
            jsonElement = this.keyTypeAdapter.toJsonTree(entry.getKey());
            arrayList.add(jsonElement);
            arrayList2.add(entry.getValue());
            bl |= jsonElement.isJsonArray() || jsonElement.isJsonObject();
        }
        if (bl) {
            jsonWriter.beginArray();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                jsonWriter.beginArray();
                Streams.write((JsonElement)arrayList.get(i), jsonWriter);
                this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i));
                jsonWriter.endArray();
            }
            jsonWriter.endArray();
            return;
        }
        jsonWriter.beginObject();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            jsonElement = (JsonElement)arrayList.get(i);
            jsonWriter.name(this.keyToString(jsonElement));
            this.valueTypeAdapter.write(jsonWriter, arrayList2.get(i));
        }
        jsonWriter.endObject();
    }

    private String keyToString(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            if (((JsonPrimitive)(jsonElement = jsonElement.getAsJsonPrimitive())).isNumber()) {
                return String.valueOf(jsonElement.getAsNumber());
            }
            if (((JsonPrimitive)jsonElement).isBoolean()) {
                return Boolean.toString(jsonElement.getAsBoolean());
            }
            if (((JsonPrimitive)jsonElement).isString()) {
                return jsonElement.getAsString();
            }
            throw new AssertionError();
        }
        if (jsonElement.isJsonNull()) {
            return "null";
        }
        throw new AssertionError();
    }
}

