/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.reflect;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.JsonIOException;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.TroubleshootingGuide;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.reflect.ReflectionHelper$RecordHelper;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.reflect.ReflectionHelper$RecordNotSupportedHelper;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.internal.reflect.ReflectionHelper$RecordSupportedHelper;

public class ReflectionHelper {
    private static final ReflectionHelper$RecordHelper RECORD_HELPER;

    private ReflectionHelper() {
    }

    private static String getInaccessibleTroubleshootingSuffix(Exception object) {
        if (object.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
            object = (object = ((Throwable)object).getMessage()) != null && ((String)object).contains("to module com.google.gson") ? "reflection-inaccessible-to-module-gson" : "reflection-inaccessible";
            return "\nSee " + TroubleshootingGuide.createUrl((String)object);
        }
        return "";
    }

    public static void makeAccessible(AccessibleObject object) {
        try {
            ((AccessibleObject)object).setAccessible(true);
            return;
        }
        catch (Exception exception) {
            object = ReflectionHelper.getAccessibleObjectDescription((AccessibleObject)object, false);
            throw new JsonIOException("Failed making " + (String)object + " accessible; either increase its visibility or write a custom TypeAdapter for its declaring type." + ReflectionHelper.getInaccessibleTroubleshootingSuffix(exception), exception);
        }
    }

    public static String getAccessibleObjectDescription(AccessibleObject object, boolean bl) {
        if (object instanceof Field) {
            object = "field '" + ReflectionHelper.fieldToString((Field)object) + "'";
        } else if (object instanceof Method) {
            object = (Method)object;
            CharSequence charSequence = new StringBuilder(((Method)object).getName());
            ReflectionHelper.appendExecutableParameters((AccessibleObject)object, charSequence);
            charSequence = charSequence.toString();
            object = "method '" + ((Method)object).getDeclaringClass().getName() + "#" + (String)charSequence + "'";
        } else {
            object = object instanceof Constructor ? "constructor '" + ReflectionHelper.constructorToString((Constructor)object) + "'" : "<unknown AccessibleObject> " + object.toString();
        }
        if (bl && Character.isLowerCase(((String)object).charAt(0))) {
            object = Character.toUpperCase(((String)object).charAt(0)) + ((String)object).substring(1);
        }
        return object;
    }

    public static String fieldToString(Field field) {
        return field.getDeclaringClass().getName() + "#" + field.getName();
    }

    public static String constructorToString(Constructor<?> constructor) {
        StringBuilder stringBuilder = new StringBuilder(constructor.getDeclaringClass().getName());
        ReflectionHelper.appendExecutableParameters(constructor, stringBuilder);
        return stringBuilder.toString();
    }

    private static void appendExecutableParameters(AccessibleObject classArray, StringBuilder stringBuilder) {
        stringBuilder.append('(');
        classArray = classArray instanceof Method ? ((Method)classArray).getParameterTypes() : ((Constructor)classArray).getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(classArray[i].getSimpleName());
        }
        stringBuilder.append(')');
    }

    public static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isAnonymousOrNonStaticLocal(Class<?> clazz) {
        return !ReflectionHelper.isStatic(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }

    public static String tryMakeAccessible(Constructor<?> constructor) {
        try {
            constructor.setAccessible(true);
            return null;
        }
        catch (Exception exception) {
            return "Failed making constructor '" + ReflectionHelper.constructorToString(constructor) + "' accessible; either increase its visibility or write a custom InstanceCreator or TypeAdapter for its declaring type: " + exception.getMessage() + ReflectionHelper.getInaccessibleTroubleshootingSuffix(exception);
        }
    }

    public static boolean isRecord(Class<?> clazz) {
        return RECORD_HELPER.isRecord(clazz);
    }

    public static String[] getRecordComponentNames(Class<?> clazz) {
        return RECORD_HELPER.getRecordComponentNames(clazz);
    }

    public static Method getAccessor(Class<?> clazz, Field field) {
        return RECORD_HELPER.getAccessor(clazz, field);
    }

    public static <T> Constructor<T> getCanonicalRecordConstructor(Class<T> clazz) {
        return RECORD_HELPER.getCanonicalRecordConstructor(clazz);
    }

    public static RuntimeException createExceptionForUnexpectedIllegalAccess(IllegalAccessException illegalAccessException) {
        throw new RuntimeException("Unexpected IllegalAccessException occurred (Gson 2.13.2). Certain ReflectionAccessFilter features require Java >= 9 to work correctly. If you are not using ReflectionAccessFilter, report this to the Gson maintainers.", illegalAccessException);
    }

    private static RuntimeException createExceptionForRecordReflectionException(ReflectiveOperationException reflectiveOperationException) {
        throw new RuntimeException("Unexpected ReflectiveOperationException occurred (Gson 2.13.2). To support Java records, reflection is utilized to read out information about records. All these invocations happens after it is established that records exist in the JVM. This exception is unexpected behavior.", reflectiveOperationException);
    }

    static /* synthetic */ RuntimeException access$300(ReflectiveOperationException reflectiveOperationException) {
        return ReflectionHelper.createExceptionForRecordReflectionException(reflectiveOperationException);
    }

    static {
        ReflectionHelper$RecordHelper reflectionHelper$RecordHelper;
        try {
            reflectionHelper$RecordHelper = new ReflectionHelper$RecordSupportedHelper(null);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            reflectionHelper$RecordHelper = new ReflectionHelper$RecordNotSupportedHelper(null);
        }
        RECORD_HELPER = reflectionHelper$RecordHelper;
    }
}

