/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.dependencies.instantrestock.gson.stream;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import me.spartacus04.instantrestock.dependencies.instantrestock.errorprone.annotations.CanIgnoreReturnValue;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.FormattingStyle;
import me.spartacus04.instantrestock.dependencies.instantrestock.gson.Strictness;

public class JsonWriter
implements Closeable,
Flushable {
    private static final Pattern VALID_JSON_NUMBER_PATTERN = Pattern.compile("-?(?:0|[1-9][0-9]*)(?:\\.[0-9]+)?(?:[eE][-+]?[0-9]+)?");
    private static final String[] REPLACEMENT_CHARS = new String[128];
    private static final String[] HTML_SAFE_REPLACEMENT_CHARS;
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    private FormattingStyle formattingStyle;
    private String formattedColon;
    private String formattedComma;
    private boolean usesEmptyNewlineAndIndent;
    private Strictness strictness;
    private boolean htmlSafe;
    private String deferredName;
    private boolean serializeNulls;

    public JsonWriter(Writer writer) {
        this.push(6);
        this.strictness = Strictness.LEGACY_STRICT;
        this.serializeNulls = true;
        this.out = Objects.requireNonNull(writer, "out == null");
        this.setFormattingStyle(FormattingStyle.COMPACT);
    }

    public final void setIndent(String string) {
        if (string.isEmpty()) {
            this.setFormattingStyle(FormattingStyle.COMPACT);
            return;
        }
        this.setFormattingStyle(FormattingStyle.PRETTY.withIndent(string));
    }

    public final void setFormattingStyle(FormattingStyle formattingStyle) {
        this.formattingStyle = Objects.requireNonNull(formattingStyle);
        this.formattedComma = ",";
        if (this.formattingStyle.usesSpaceAfterSeparators()) {
            this.formattedColon = ": ";
            if (this.formattingStyle.getNewline().isEmpty()) {
                this.formattedComma = ", ";
            }
        } else {
            this.formattedColon = ":";
        }
        this.usesEmptyNewlineAndIndent = this.formattingStyle.getNewline().isEmpty() && this.formattingStyle.getIndent().isEmpty();
    }

    public final FormattingStyle getFormattingStyle() {
        return this.formattingStyle;
    }

    @Deprecated
    public final void setLenient(boolean bl) {
        this.setStrictness(bl ? Strictness.LENIENT : Strictness.LEGACY_STRICT);
    }

    public boolean isLenient() {
        return this.strictness == Strictness.LENIENT;
    }

    public final void setStrictness(Strictness strictness) {
        this.strictness = Objects.requireNonNull(strictness);
    }

    public final Strictness getStrictness() {
        return this.strictness;
    }

    public final void setHtmlSafe(boolean bl) {
        this.htmlSafe = bl;
    }

    public final boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public final void setSerializeNulls(boolean bl) {
        this.serializeNulls = bl;
    }

    public final boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    @CanIgnoreReturnValue
    public JsonWriter beginArray() {
        this.writeDeferredName();
        return this.openScope(1, '[');
    }

    @CanIgnoreReturnValue
    public JsonWriter endArray() {
        return this.closeScope(1, 2, ']');
    }

    @CanIgnoreReturnValue
    public JsonWriter beginObject() {
        this.writeDeferredName();
        return this.openScope(3, '{');
    }

    @CanIgnoreReturnValue
    public JsonWriter endObject() {
        return this.closeScope(3, 5, '}');
    }

    @CanIgnoreReturnValue
    private JsonWriter openScope(int n, char c) {
        this.beforeValue();
        this.push(n);
        this.out.write(c);
        return this;
    }

    @CanIgnoreReturnValue
    private JsonWriter closeScope(int n, int n2, char c) {
        int n3 = this.peek();
        if (n3 != n2 && n3 != n) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        if (n3 == n2) {
            this.newline();
        }
        this.out.write(c);
        return this;
    }

    private void push(int n) {
        if (this.stackSize == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stackSize << 1);
        }
        this.stack[this.stackSize++] = n;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int n) {
        this.stack[this.stackSize - 1] = n;
    }

    @CanIgnoreReturnValue
    public JsonWriter name(String string) {
        Objects.requireNonNull(string, "name == null");
        if (this.deferredName != null) {
            throw new IllegalStateException("Already wrote a name, expecting a value.");
        }
        int n = this.peek();
        if (n != 3 && n != 5) {
            throw new IllegalStateException("Please begin an object before writing a name.");
        }
        this.deferredName = string;
        return this;
    }

    private void writeDeferredName() {
        if (this.deferredName != null) {
            this.beforeName();
            JsonWriter jsonWriter = this;
            jsonWriter.string(jsonWriter.deferredName);
            this.deferredName = null;
        }
    }

    @CanIgnoreReturnValue
    public JsonWriter value(String string) {
        if (string == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(string);
        return this;
    }

    @CanIgnoreReturnValue
    public JsonWriter value(boolean bl) {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(bl ? "true" : "false");
        return this;
    }

    @CanIgnoreReturnValue
    public JsonWriter value(Boolean bl) {
        if (bl == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(bl != false ? "true" : "false");
        return this;
    }

    @CanIgnoreReturnValue
    public JsonWriter value(float f) {
        this.writeDeferredName();
        if (this.strictness != Strictness.LENIENT && (Float.isNaN(f) || Float.isInfinite(f))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + f);
        }
        this.beforeValue();
        this.out.append(Float.toString(f));
        return this;
    }

    @CanIgnoreReturnValue
    public JsonWriter value(double d) {
        this.writeDeferredName();
        if (this.strictness != Strictness.LENIENT && (Double.isNaN(d) || Double.isInfinite(d))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + d);
        }
        this.beforeValue();
        this.out.append(Double.toString(d));
        return this;
    }

    @CanIgnoreReturnValue
    public JsonWriter value(long l) {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString(l));
        return this;
    }

    @CanIgnoreReturnValue
    public JsonWriter value(Number serializable) {
        if (serializable == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = serializable.toString();
        serializable = serializable.getClass();
        if (!JsonWriter.alwaysCreatesValidJsonNumber(serializable)) {
            if (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN")) {
                if (this.strictness != Strictness.LENIENT) {
                    throw new IllegalArgumentException("Numeric values must be finite, but was " + string);
                }
            } else if (serializable != Float.class && serializable != Double.class && !VALID_JSON_NUMBER_PATTERN.matcher(string).matches()) {
                throw new IllegalArgumentException("String created by " + serializable + " is not a valid JSON number: " + string);
            }
        }
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    @CanIgnoreReturnValue
    public JsonWriter nullValue() {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    @CanIgnoreReturnValue
    public JsonWriter jsonValue(String string) {
        if (string == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    @Override
    public void flush() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    @Override
    public void close() {
        this.out.close();
        int n = this.stackSize;
        if (n > 1 || n == 1 && this.stack[n - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private static boolean alwaysCreatesValidJsonNumber(Class<? extends Number> clazz) {
        return clazz == Integer.class || clazz == Long.class || clazz == Byte.class || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == AtomicInteger.class || clazz == AtomicLong.class;
    }

    private void string(String string) {
        String[] stringArray = this.htmlSafe ? HTML_SAFE_REPLACEMENT_CHARS : REPLACEMENT_CHARS;
        this.out.write(34);
        int n = 0;
        int n2 = string.length();
        for (int i = 0; i < n2; ++i) {
            String string2;
            char c = string.charAt(i);
            if (c < '\u0080') {
                string2 = stringArray[c];
                if (string2 == null) {
                    continue;
                }
            } else if (c == '\u2028') {
                string2 = "\\u2028";
            } else {
                if (c != '\u2029') continue;
                string2 = "\\u2029";
            }
            if (n < i) {
                this.out.write(string, n, i - n);
            }
            this.out.write(string2);
            n = i + 1;
        }
        if (n < n2) {
            this.out.write(string, n, n2 - n);
        }
        this.out.write(34);
    }

    private void newline() {
        if (this.usesEmptyNewlineAndIndent) {
            return;
        }
        this.out.write(this.formattingStyle.getNewline());
        int n = this.stackSize;
        for (int i = 1; i < n; ++i) {
            this.out.write(this.formattingStyle.getIndent());
        }
    }

    private void beforeName() {
        int n = this.peek();
        if (n == 5) {
            this.out.write(this.formattedComma);
        } else if (n != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue() {
        switch (this.peek()) {
            case 7: {
                if (this.strictness != Strictness.LENIENT) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.replaceTop(7);
                return;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                return;
            }
            case 2: {
                this.out.append(this.formattedComma);
                this.newline();
                return;
            }
            case 4: {
                this.out.append(this.formattedColon);
                this.replaceTop(5);
                return;
            }
        }
        throw new IllegalStateException("Nesting problem.");
    }

    static {
        for (int i = 0; i <= 31; ++i) {
            JsonWriter.REPLACEMENT_CHARS[i] = String.format("\\u%04x", i);
        }
        JsonWriter.REPLACEMENT_CHARS[34] = "\\\"";
        JsonWriter.REPLACEMENT_CHARS[92] = "\\\\";
        JsonWriter.REPLACEMENT_CHARS[9] = "\\t";
        JsonWriter.REPLACEMENT_CHARS[8] = "\\b";
        JsonWriter.REPLACEMENT_CHARS[10] = "\\n";
        JsonWriter.REPLACEMENT_CHARS[13] = "\\r";
        JsonWriter.REPLACEMENT_CHARS[12] = "\\f";
        String[] stringArray = (String[])REPLACEMENT_CHARS.clone();
        HTML_SAFE_REPLACEMENT_CHARS = stringArray;
        stringArray[60] = "\\u003c";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[62] = "\\u003e";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[38] = "\\u0026";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[61] = "\\u003d";
        JsonWriter.HTML_SAFE_REPLACEMENT_CHARS[39] = "\\u0027";
    }
}

