/*
 * Decompiled with CFR 0.152.
 */
package me.spartacus04.instantrestock.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import me.spartacus04.colosseum.ColosseumPlugin;
import me.spartacus04.colosseum.listeners.ColosseumListener;
import me.spartacus04.instantrestock.InstantRestock;
import me.spartacus04.instantrestock.TradesDataType;
import me.spartacus04.instantrestock.dependencies.instantrestock.annotations.NotNull;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.Metadata;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.collections.CollectionsKt;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.jvm.internal.Intrinsics;
import me.spartacus04.instantrestock.dependencies.instantrestock.kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.AbstractVillager;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.VillagerAcquireTradeEvent;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lme/spartacus04/instantrestock/listeners/VillagerEvent;", "Lme/spartacus04/colosseum/listeners/ColosseumListener;", "plugin", "Lme/spartacus04/colosseum/ColosseumPlugin;", "<init>", "(Lme/spartacus04/colosseum/ColosseumPlugin;)V", "onPlayerInteractAtEntityEvent", "", "e", "Lorg/bukkit/event/player/PlayerInteractAtEntityEvent;", "onVillagerUpgrade", "Lorg/bukkit/event/entity/VillagerAcquireTradeEvent;", "saveVillagerTrades", "villager", "Lorg/bukkit/entity/AbstractVillager;", "restoreVillagerTrades", "setMaxTrades", "maxTrades", "", "getProfessionKey", "", "Lorg/bukkit/entity/Villager;", "instantrestock"})
@SourceDebugExtension(value={"SMAP\nVillagerEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VillagerEvent.kt\nme/spartacus04/instantrestock/listeners/VillagerEvent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,119:1\n1563#2:120\n1634#2,3:121\n1878#2,3:124\n1869#2,2:127\n*S KotlinDebug\n*F\n+ 1 VillagerEvent.kt\nme/spartacus04/instantrestock/listeners/VillagerEvent\n*L\n74#1:120\n74#1:121,3\n82#1:124,3\n93#1:127,2\n*E\n"})
public final class VillagerEvent
extends ColosseumListener {
    @NotNull
    private final ColosseumPlugin plugin;

    public VillagerEvent(@NotNull ColosseumPlugin colosseumPlugin) {
        Intrinsics.checkNotNullParameter((Object)colosseumPlugin, "plugin");
        super(colosseumPlugin);
        this.plugin = colosseumPlugin;
    }

    @EventHandler
    public final void onPlayerInteractAtEntityEvent(@NotNull PlayerInteractAtEntityEvent playerInteractAtEntityEvent) {
        Intrinsics.checkNotNullParameter(playerInteractAtEntityEvent, "e");
        if (!(playerInteractAtEntityEvent.getRightClicked() instanceof AbstractVillager)) {
            return;
        }
        Entity entity = playerInteractAtEntityEvent.getRightClicked();
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.entity.AbstractVillager");
        playerInteractAtEntityEvent = (AbstractVillager)entity;
        if (InstantRestock.Companion.getCONFIG().getUNINSTALL_MODE()) {
            if (playerInteractAtEntityEvent.getPersistentDataContainer().has(InstantRestock.Companion.getKEY(), (PersistentDataType)new TradesDataType())) {
                this.restoreVillagerTrades((AbstractVillager)playerInteractAtEntityEvent);
                playerInteractAtEntityEvent.getPersistentDataContainer().remove(InstantRestock.Companion.getKEY());
            }
            return;
        }
        if (playerInteractAtEntityEvent.getType() == EntityType.WANDERING_TRADER && !InstantRestock.Companion.getCONFIG().getALLOW_TRAVELLING_MERCHANTS()) {
            if (playerInteractAtEntityEvent.getPersistentDataContainer().has(InstantRestock.Companion.getKEY(), (PersistentDataType)new TradesDataType())) {
                this.restoreVillagerTrades((AbstractVillager)playerInteractAtEntityEvent);
                playerInteractAtEntityEvent.getPersistentDataContainer().remove(InstantRestock.Companion.getKEY());
            }
            return;
        }
        if (playerInteractAtEntityEvent.getType() == EntityType.VILLAGER) {
            ArrayList<String> arrayList = InstantRestock.Companion.getCONFIG().getVILLAGER_BLACKLIST();
            String string = this.getProfessionKey((Villager)playerInteractAtEntityEvent).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
            if (arrayList.contains(string)) {
                if (((Villager)playerInteractAtEntityEvent).getPersistentDataContainer().has(InstantRestock.Companion.getKEY(), (PersistentDataType)new TradesDataType())) {
                    this.restoreVillagerTrades((AbstractVillager)playerInteractAtEntityEvent);
                    ((Villager)playerInteractAtEntityEvent).getPersistentDataContainer().remove(InstantRestock.Companion.getKEY());
                }
                return;
            }
        }
        if (!playerInteractAtEntityEvent.getPersistentDataContainer().has(InstantRestock.Companion.getKEY(), (PersistentDataType)new TradesDataType())) {
            this.saveVillagerTrades((AbstractVillager)playerInteractAtEntityEvent);
        }
        this.setMaxTrades((AbstractVillager)playerInteractAtEntityEvent, InstantRestock.Companion.getCONFIG().getMAX_TRADES());
    }

    @EventHandler
    public final void onVillagerUpgrade(@NotNull VillagerAcquireTradeEvent villagerAcquireTradeEvent) {
        Intrinsics.checkNotNullParameter(villagerAcquireTradeEvent, "e");
        AbstractVillager abstractVillager = villagerAcquireTradeEvent.getEntity();
        Intrinsics.checkNotNullExpressionValue(abstractVillager, "getEntity(...)");
        villagerAcquireTradeEvent = abstractVillager;
        if (InstantRestock.Companion.getCONFIG().getUNINSTALL_MODE()) {
            return;
        }
        if (villagerAcquireTradeEvent.getType() == EntityType.WANDERING_TRADER && !InstantRestock.Companion.getCONFIG().getALLOW_TRAVELLING_MERCHANTS()) {
            return;
        }
        if (villagerAcquireTradeEvent.getPersistentDataContainer().has(InstantRestock.Companion.getKEY(), (PersistentDataType)new TradesDataType())) {
            this.restoreVillagerTrades((AbstractVillager)villagerAcquireTradeEvent);
            this.saveVillagerTrades((AbstractVillager)villagerAcquireTradeEvent);
            this.setMaxTrades((AbstractVillager)villagerAcquireTradeEvent, InstantRestock.Companion.getCONFIG().getMAX_TRADES());
        }
    }

    private final void saveVillagerTrades(AbstractVillager object) {
        List list;
        PersistentDataContainer persistentDataContainer = object.getPersistentDataContainer();
        NamespacedKey namespacedKey = InstantRestock.Companion.getKEY();
        PersistentDataType persistentDataType = new TradesDataType();
        List list2 = object.getRecipes();
        Intrinsics.checkNotNullExpressionValue(list2, "getRecipes(...)");
        object = list2;
        PersistentDataType persistentDataType2 = persistentDataType;
        NamespacedKey namespacedKey2 = namespacedKey;
        PersistentDataContainer persistentDataContainer2 = persistentDataContainer;
        Object object2 = object;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault(object, 10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (MerchantRecipe)object3;
            list = object;
            list.add(object3.getMaxUses());
        }
        list = (List)object;
        persistentDataContainer2.set(namespacedKey2, persistentDataType2, (Object)CollectionsKt.toIntArray(list));
    }

    private final void restoreVillagerTrades(AbstractVillager object) {
        if (!object.getPersistentDataContainer().has(InstantRestock.Companion.getKEY(), (PersistentDataType)new TradesDataType())) {
            return;
        }
        int[] nArray = (int[])object.getPersistentDataContainer().get(InstantRestock.Companion.getKEY(), (PersistentDataType)new TradesDataType());
        if (nArray == null) {
            return;
        }
        int[] nArray2 = nArray;
        List list = object.getRecipes();
        Intrinsics.checkNotNullExpressionValue(list, "getRecipes(...)");
        object = list;
        int n = 0;
        object = object.iterator();
        while (object.hasNext()) {
            int n2;
            Object object2 = object.next();
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object2 = (MerchantRecipe)object2;
            try {
                object2.setMaxUses(nArray2[n2]);
            }
            catch (Exception exception) {}
        }
    }

    private final void setMaxTrades(AbstractVillager object, int n) {
        List list = object.getRecipes();
        Intrinsics.checkNotNullExpressionValue(list, "getRecipes(...)");
        object = list;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (MerchantRecipe)object2;
            object2.setMaxUses(n <= 0 ? Integer.MAX_VALUE : n);
            if (InstantRestock.Companion.getCONFIG().getMAX_TRADES() == Integer.MAX_VALUE) {
                object2.setUses(0);
            }
            if (this.plugin.getServerVersion().compareTo("1.18") < 0 || !InstantRestock.Companion.getCONFIG().getDISABLE_PRICE_PENALTY()) continue;
            object2.setDemand(0);
        }
    }

    private final String getProfessionKey(Villager object) {
        object = object.getClass().getMethod("getProfession", new Class[0]).invoke(object, new Object[0]);
        object = object.getClass().getMethod("getKey", new Class[0]).invoke(object, new Object[0]);
        object = object.getClass().getMethod("getKey", new Class[0]).invoke(object, new Object[0]);
        return object.toString();
    }
}

