/*
 * Decompiled with CFR 0.152.
 */
package me.artofluxis.project.listeners;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.artofluxis.project.listeners.GlobalListenerKt;
import me.artofluxis.project.util.ConfigUtilKt;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\rH\u0007\u00a8\u0006\u000e"}, d2={"Lme/artofluxis/project/listeners/GlobalListener;", "Lorg/bukkit/event/Listener;", "<init>", "()V", "onEntityDamage", "", "event", "Lorg/bukkit/event/entity/EntityDamageEvent;", "onBlockBreak1", "Lorg/bukkit/event/block/BlockBreakEvent;", "onBlockBreak2", "Lorg/bukkit/event/block/BlockExplodeEvent;", "onBlockBreak3", "Lorg/bukkit/event/entity/EntityExplodeEvent;", "ThisMakesSenseNow"})
@SourceDebugExtension(value={"SMAP\nGlobalListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalListener.kt\nme/artofluxis/project/listeners/GlobalListener\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,92:1\n32#2,2:93\n32#2,2:95\n*S KotlinDebug\n*F\n+ 1 GlobalListener.kt\nme/artofluxis/project/listeners/GlobalListener\n*L\n85#1:93,2\n90#1:95,2\n*E\n"})
public final class GlobalListener
implements Listener {
    @NotNull
    public static final GlobalListener INSTANCE = new GlobalListener();

    private GlobalListener() {
    }

    @EventHandler
    public final void onEntityDamage(@NotNull EntityDamageEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"getEntity(...)");
        Entity entity2 = entity;
        if (entity2 instanceof Item) {
            ItemStack itemStack = ((Item)entity2).getItemStack();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
            ItemStack itemStack2 = itemStack;
            Material material = itemStack2.getType();
            Intrinsics.checkNotNullExpressionValue((Object)material, (String)"getType(...)");
            Material itemStackType = material;
            if (event.getCause() == EntityDamageEvent.DamageCause.LAVA) {
                if (ConfigUtilKt.loadMaterialList("unflammable_items").contains(itemStackType)) {
                    event.setCancelled(true);
                } else {
                    HashMap<Material, Pair<Material, Integer>> resultsMap = ConfigUtilKt.loadMaterialMap("flammable_items");
                    if (((Map)resultsMap).containsKey(itemStackType)) {
                        event.setCancelled(true);
                        Pair<Material, Integer> pair = resultsMap.get(itemStackType);
                        Intrinsics.checkNotNull(pair);
                        Pair<Material, Integer> result = pair;
                        int amount = ((Number)result.getSecond()).intValue() * itemStack2.getAmount();
                        ItemMeta meta = itemStack2.getItemMeta();
                        if (meta instanceof Damageable && itemStackType.getMaxDurability() > 0) {
                            amount = (int)((double)amount * (double)(itemStackType.getMaxDurability() - ((Damageable)meta).getDamage()) / (double)itemStackType.getMaxDurability());
                        }
                        if (amount > 0) {
                            ((Item)entity2).setItemStack(new ItemStack((Material)result.getFirst(), amount));
                        } else {
                            event.setCancelled(false);
                        }
                    }
                }
            } else {
                Object[] objectArray = new EntityDamageEvent.DamageCause[]{EntityDamageEvent.DamageCause.ENTITY_EXPLOSION, EntityDamageEvent.DamageCause.BLOCK_EXPLOSION};
                if (SetsKt.hashSetOf((Object[])objectArray).contains(event.getCause()) && ConfigUtilKt.loadMaterialList("unexplodable_items").contains(itemStackType)) {
                    event.setCancelled(true);
                }
            }
        }
    }

    @EventHandler
    public final void onBlockBreak1(@NotNull BlockBreakEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Block block = event.getBlock();
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
        GlobalListenerKt.access$onBlockBreakInAnyWay(block);
    }

    @EventHandler
    public final void onBlockBreak2(@NotNull BlockExplodeEvent event) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterator $this$forEach$iv = iterator = event.blockList().iterator();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Block it = (Block)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            GlobalListenerKt.access$onBlockBreakInAnyWay(it);
        }
    }

    @EventHandler
    public final void onBlockBreak3(@NotNull EntityExplodeEvent event) {
        Iterator iterator;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Iterator $this$forEach$iv = iterator = event.blockList().iterator();
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Block it = (Block)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            GlobalListenerKt.access$onBlockBreakInAnyWay(it);
        }
    }
}

