package fluffymoment.ironbarrels;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3708;
import net.minecraft.class_3719;
import net.minecraft.class_3965;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import fluffymoment.ironbarrels.init.IronBarrelsBlocks;
import fluffymoment.ironbarrels.init.IronBarrelsBlockEntities;
import fluffymoment.ironbarrels.init.IronBarrelsItems;
import fluffymoment.ironbarrels.init.IronBarrelsSounds;
import fluffymoment.ironbarrels.init.IronBarrelsMenus;
import fluffymoment.ironbarrels.init.IronBarrelsTabs;
import fluffymoment.ironbarrels.block.IronBarrelBlock;
import fluffymoment.ironbarrels.block.GoldBarrelBlock;
import fluffymoment.ironbarrels.block.DiamondBarrelBlock;
import fluffymoment.ironbarrels.block.ObsidianBarrelBlock;
import fluffymoment.ironbarrels.block.NetheriteBarrelBlock;
import fluffymoment.ironbarrels.block.entity.IronBarrelBlockEntity;
import fluffymoment.ironbarrels.block.entity.GoldBarrelBlockEntity;
import fluffymoment.ironbarrels.block.entity.DiamondBarrelBlockEntity;
import fluffymoment.ironbarrels.block.entity.ObsidianBarrelBlockEntity;
import fluffymoment.ironbarrels.block.entity.NetheriteBarrelBlockEntity;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.Collection;
import java.util.List;
import java.util.ArrayList;

public class IronBarrels implements ModInitializer {
	public static final String MOD_ID = "ironbarrels";
	public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

	private static final Collection<WorkQueueEntry> workQueue = new ConcurrentLinkedQueue<>();

	@Override
	public void onInitialize() {
		LOGGER.info("Initializing Iron Barrels mod");

		// Register mod content
		IronBarrelsSounds.register();
		IronBarrelsBlocks.register();
		IronBarrelsBlockEntities.register();
		IronBarrelsItems.register();
		IronBarrelsTabs.register();
		IronBarrelsMenus.register();

		// Register server tick event for work queue
		ServerTickEvents.END_SERVER_TICK.register(server -> {
			List<WorkQueueEntry> actions = new ArrayList<>();
			workQueue.forEach(work -> {
				work.ticksRemaining--;
				if (work.ticksRemaining <= 0)
					actions.add(work);
			});
			actions.forEach(e -> e.action.run());
			workQueue.removeAll(actions);
		});

		// Intercept right-clicks to handle upgrade items before blocks open their GUIs
		UseBlockCallback.EVENT.register((class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) -> {
			class_1799 stack = player.method_5998(hand);
			if (stack.method_7960()) return class_1269.field_5811;

			// Only when sneaking with any upgrade item
			if (!player.method_5715()) return class_1269.field_5811;

			class_2338 pos = hit.method_17777();
			class_2680 state = world.method_8320(pos);

			// Determine which upgrade applies at this position
			boolean applies = false;
			Runnable applyUpgrade = null;

			// 1) Wood -> Iron (vanilla barrel -> iron barrel)
			if (stack.method_31574(IronBarrelsItems.WOOD_TO_IRON_BARREL_UPGRADE) && state.method_27852(class_2246.field_16328)) {
				applies = true;
				applyUpgrade = () -> {
					class_2586 oldBe = world.method_8321(pos);
					if (!(oldBe instanceof class_3719 oldBarrel)) return;
					int oldSize = oldBarrel.method_5439();
					class_1799[] carried = new class_1799[oldSize];
					for (int i = 0; i < oldSize; i++) {
						class_1799 s = oldBarrel.method_5438(i);
						carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
						oldBarrel.method_5447(i, class_1799.field_8037);
					}
					class_2350 facing = state.method_11654(class_3708.field_16320);
					class_2680 newState = IronBarrelsBlocks.IRON_BARREL.method_9564().method_11657(IronBarrelBlock.FACING, facing);
					world.method_8652(pos, newState, 3);
					class_2586 newBe = world.method_8321(pos);
					if (newBe instanceof IronBarrelBlockEntity ironBe) {
						int newSize = ironBe.method_5439();
						int limit = Math.min(oldSize, newSize);
						for (int i = 0; i < limit; i++) {
							ironBe.method_5447(i, carried[i].method_7972());
						}
						ironBe.method_5431();
					}
				};
			}

			// 2) Iron -> Gold
			if (stack.method_31574(IronBarrelsItems.IRON_TO_GOLD_BARREL_UPGRADE) && state.method_27852(IronBarrelsBlocks.IRON_BARREL)) {
				applies = true;
				applyUpgrade = () -> {
					class_2586 oldBe = world.method_8321(pos);
					if (!(oldBe instanceof IronBarrelBlockEntity oldBarrel)) return;
					int oldSize = oldBarrel.method_5439();
					class_1799[] carried = new class_1799[oldSize];
					for (int i = 0; i < oldSize; i++) {
						class_1799 s = oldBarrel.method_5438(i);
						carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
						oldBarrel.method_5447(i, class_1799.field_8037);
					}
					class_2350 facing = state.method_11654(IronBarrelBlock.FACING);
					class_2680 newState = IronBarrelsBlocks.GOLD_BARREL.method_9564().method_11657(GoldBarrelBlock.FACING, facing);
					world.method_8652(pos, newState, 3);
					class_2586 newBe = world.method_8321(pos);
					if (newBe instanceof GoldBarrelBlockEntity goldBe) {
						int newSize = goldBe.method_5439();
						int limit = Math.min(oldSize, newSize);
						for (int i = 0; i < limit; i++) {
							goldBe.method_5447(i, carried[i].method_7972());
						}
						goldBe.method_5431();
					}
				};
			}

			// 3) Gold -> Diamond
			if (stack.method_31574(IronBarrelsItems.GOLD_TO_DIAMOND_BARREL_UPGRADE) && state.method_27852(IronBarrelsBlocks.GOLD_BARREL)) {
				applies = true;
				applyUpgrade = () -> {
					class_2586 oldBe = world.method_8321(pos);
					if (!(oldBe instanceof GoldBarrelBlockEntity oldBarrel)) return;
					int oldSize = oldBarrel.method_5439();
					class_1799[] carried = new class_1799[oldSize];
					for (int i = 0; i < oldSize; i++) {
						class_1799 s = oldBarrel.method_5438(i);
						carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
						oldBarrel.method_5447(i, class_1799.field_8037);
					}
					class_2350 facing = state.method_11654(GoldBarrelBlock.FACING);
					class_2680 newState = IronBarrelsBlocks.DIAMOND_BARREL.method_9564().method_11657(DiamondBarrelBlock.FACING, facing);
					world.method_8652(pos, newState, 3);
					class_2586 newBe = world.method_8321(pos);
					if (newBe instanceof DiamondBarrelBlockEntity diamondBe) {
						int newSize = diamondBe.method_5439();
						int limit = Math.min(oldSize, newSize);
						for (int i = 0; i < limit; i++) {
							diamondBe.method_5447(i, carried[i].method_7972());
						}
						diamondBe.method_5431();
					}
				};
			}

			// 4) Diamond -> Obsidian
			if (stack.method_31574(IronBarrelsItems.DIAMOND_TO_OBSIDIAN_BARREL_UPGRADE) && state.method_27852(IronBarrelsBlocks.DIAMOND_BARREL)) {
				applies = true;
				applyUpgrade = () -> {
					class_2586 oldBe = world.method_8321(pos);
					if (!(oldBe instanceof DiamondBarrelBlockEntity oldBarrel)) return;
					int oldSize = oldBarrel.method_5439();
					class_1799[] carried = new class_1799[oldSize];
					for (int i = 0; i < oldSize; i++) {
						class_1799 s = oldBarrel.method_5438(i);
						carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
						oldBarrel.method_5447(i, class_1799.field_8037);
					}
					class_2350 facing = state.method_11654(DiamondBarrelBlock.FACING);
					class_2680 newState = IronBarrelsBlocks.OBSIDIAN_BARREL.method_9564().method_11657(ObsidianBarrelBlock.FACING, facing);
					world.method_8652(pos, newState, 3);
					class_2586 newBe = world.method_8321(pos);
					if (newBe instanceof ObsidianBarrelBlockEntity obsBe) {
						int newSize = obsBe.method_5439();
						int limit = Math.min(oldSize, newSize);
						for (int i = 0; i < limit; i++) {
							obsBe.method_5447(i, carried[i].method_7972());
						}
						obsBe.method_5431();
					}
				};
			}

			// 5) Obsidian -> Netherite
			if (stack.method_31574(IronBarrelsItems.OBSIDIAN_TO_NETHERITE_BARREL_UPGRADE) && state.method_27852(IronBarrelsBlocks.OBSIDIAN_BARREL)) {
				applies = true;
				applyUpgrade = () -> {
					class_2586 oldBe = world.method_8321(pos);
					if (!(oldBe instanceof ObsidianBarrelBlockEntity oldBarrel)) return;
					int oldSize = oldBarrel.method_5439();
					class_1799[] carried = new class_1799[oldSize];
					for (int i = 0; i < oldSize; i++) {
						class_1799 s = oldBarrel.method_5438(i);
						carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
						oldBarrel.method_5447(i, class_1799.field_8037);
					}
					class_2350 facing = state.method_11654(ObsidianBarrelBlock.FACING);
					class_2680 newState = IronBarrelsBlocks.NETHERITE_BARREL.method_9564().method_11657(NetheriteBarrelBlock.FACING, facing);
					world.method_8652(pos, newState, 3);
					class_2586 newBe = world.method_8321(pos);
					if (newBe instanceof NetheriteBarrelBlockEntity netheriteBe) {
						int newSize = netheriteBe.method_5439();
						int limit = Math.min(oldSize, newSize);
						for (int i = 0; i < limit; i++) {
							netheriteBe.method_5447(i, carried[i].method_7972());
						}
						netheriteBe.method_5431();
					}
				};
			}

			if (!applies) return class_1269.field_5811;

			// Client: consume interaction to prevent GUI; Server: perform upgrade
			if (world.method_8608()) {
				return class_1269.field_5812;
			}

			// Apply server-side upgrade
			applyUpgrade.run();

			// Consume the upgrade (unless creative)
			if (!player.method_31549().field_7477) {
				stack.method_7934(1);
			}

			// Feedback (quieter sound, no on-screen message)
			world.method_8396(null, pos, class_3417.field_14559, class_3419.field_15245, 0.4f, 1.2f);

			return class_1269.field_5812;
		});

		LOGGER.info("Iron Barrels mod initialized successfully");
	}

	public static void queueServerWork(int tick, Runnable action) {
		workQueue.add(new WorkQueueEntry(action, tick));
	}

	private static class WorkQueueEntry {
		public final Runnable action;
		public int ticksRemaining;

		public WorkQueueEntry(Runnable action, int ticksRemaining) {
			this.action = action;
			this.ticksRemaining = ticksRemaining;
		}
	}
}