package fluffymoment.ironbarrels.init;

import java.util.function.Function;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import fluffymoment.ironbarrels.IronBarrels;
import fluffymoment.ironbarrels.block.IronBarrelBlock;
import fluffymoment.ironbarrels.block.GoldBarrelBlock;
import fluffymoment.ironbarrels.block.DiamondBarrelBlock;
import fluffymoment.ironbarrels.block.ObsidianBarrelBlock;
import fluffymoment.ironbarrels.block.NetheriteBarrelBlock;

public class IronBarrelsBlocks {
    public static final class_2248 IRON_BARREL = registerBlock(
            "iron_barrel",
            settings -> new IronBarrelBlock(settings),
            5.0f, 6.0f
    );
    public static final class_2248 GOLD_BARREL = registerBlock(
            "gold_barrel",
            settings -> new GoldBarrelBlock(settings),
            5.0f, 6.0f
    );
    public static final class_2248 DIAMOND_BARREL = registerBlock(
            "diamond_barrel",
            settings -> new DiamondBarrelBlock(settings),
            6.0f, 6.0f
    );
    public static final class_2248 OBSIDIAN_BARREL = registerBlock(
            "obsidian_barrel",
            settings -> new ObsidianBarrelBlock(settings),
            50.0f, 1200.0f
    );
    public static final class_2248 NETHERITE_BARREL = registerBlock(
            "netherite_barrel",
            settings -> new NetheriteBarrelBlock(settings),
            50.0f, 1200.0f
    );

    private static class_2248 registerBlock(String name, Function<class_2248.Settings, class_2248> factory, float hardness, float resistance) {
        class_2960 id = class_2960.method_60655(IronBarrels.MOD_ID, name);
        class_2248.Settings settings = class_2248.Settings.method_9637()
                .method_9626(class_2498.field_11533)
                .method_9629(hardness, resistance)
                .method_29292()
                .method_63500(class_5321.method_29179(class_7924.field_41254, id));
        class_2248 block = factory.apply(settings);
        return class_2378.method_10230(class_7923.field_41175, id, block);
    }

    public static void register() {
        IronBarrels.LOGGER.info("Registering blocks for " + IronBarrels.MOD_ID);
    }
}
