package fluffymoment.ironbarrels.init;

import fluffymoment.ironbarrels.IronBarrels;
import fluffymoment.ironbarrels.item.WoodToIronBarrelUpgradeItem;
import fluffymoment.ironbarrels.item.IronToGoldBarrelUpgradeItem;
import fluffymoment.ironbarrels.item.GoldToDiamondBarrelUpgradeItem;
import fluffymoment.ironbarrels.item.DiamondToObsidianBarrelUpgradeItem;
import fluffymoment.ironbarrels.item.ObsidianToNetheriteBarrelUpgradeItem;
import java.util.function.Function;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class IronBarrelsItems {
    // Block Items
    public static final class_1792 IRON_BARREL = registerBlockItem("iron_barrel", IronBarrelsBlocks.IRON_BARREL);
    public static final class_1792 GOLD_BARREL = registerBlockItem("gold_barrel", IronBarrelsBlocks.GOLD_BARREL);
    public static final class_1792 DIAMOND_BARREL = registerBlockItem("diamond_barrel", IronBarrelsBlocks.DIAMOND_BARREL);
    public static final class_1792 OBSIDIAN_BARREL = registerBlockItem("obsidian_barrel", IronBarrelsBlocks.OBSIDIAN_BARREL);
    public static final class_1792 NETHERITE_BARREL = registerBlockItem("netherite_barrel", IronBarrelsBlocks.NETHERITE_BARREL);

    // Upgrade Items
    public static final class_1792 WOOD_TO_IRON_BARREL_UPGRADE = registerItem("wood_to_iron_barrel_upgrade", settings -> new WoodToIronBarrelUpgradeItem(settings.method_7889(16)));
    public static final class_1792 IRON_TO_GOLD_BARREL_UPGRADE = registerItem("iron_to_gold_barrel_upgrade", settings -> new IronToGoldBarrelUpgradeItem(settings.method_7889(16)));
    public static final class_1792 GOLD_TO_DIAMOND_BARREL_UPGRADE = registerItem("gold_to_diamond_barrel_upgrade", settings -> new GoldToDiamondBarrelUpgradeItem(settings.method_7889(16)));
    public static final class_1792 DIAMOND_TO_OBSIDIAN_BARREL_UPGRADE = registerItem("diamond_to_obsidian_barrel_upgrade", settings -> new DiamondToObsidianBarrelUpgradeItem(settings.method_7889(16)));
    public static final class_1792 OBSIDIAN_TO_NETHERITE_BARREL_UPGRADE = registerItem("obsidian_to_netherite_barrel_upgrade", settings -> new ObsidianToNetheriteBarrelUpgradeItem(settings.method_7889(16)));

    private static class_1792 registerItem(String name, Function<class_1792.class_1793, class_1792> factory) {
        class_2960 id = class_2960.method_60655(IronBarrels.MOD_ID, name);
        class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179(class_7924.field_41197, id));
        class_1792 item = factory.apply(settings);
        return class_2378.method_10230(class_7923.field_41178, id, item);
    }

    private static class_1792 registerBlockItem(String name, class_2248 block) {
        class_2960 id = class_2960.method_60655(IronBarrels.MOD_ID, name);
        class_1792.class_1793 settings = new class_1792.class_1793().method_63686(class_5321.method_29179(class_7924.field_41197, id));
        return class_2378.method_10230(class_7923.field_41178, id, new class_1747(block, settings));
    }

    public static void register() {
        IronBarrels.LOGGER.info("Registering items for " + IronBarrels.MOD_ID);
    }
}
