package fluffymoment.ironbarrels.screen;

import fluffymoment.ironbarrels.init.IronBarrelsMenus;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class GoldBarrelScreenHandler extends class_1703 {
	private final class_1263 inventory;
	private static final int BARREL_SIZE = 81; // 9 rows x 9 columns

	public GoldBarrelScreenHandler(int syncId, class_1661 playerInventory) {
		this(syncId, playerInventory, new class_1277(BARREL_SIZE));
	}

	public GoldBarrelScreenHandler(int syncId, class_1661 playerInventory, class_1263 inventory) {
		super(IronBarrelsMenus.GOLD_BARREL, syncId);
		this.inventory = inventory;
		
		method_17359(inventory, BARREL_SIZE);
		inventory.method_5435(playerInventory.field_7546);

		// Add barrel slots (9 rows x 9 columns)
		for (int row = 0; row < 9; row++) {
			for (int col = 0; col < 9; col++) {
				int slotIndex = col + row * 9;
				if (slotIndex < BARREL_SIZE) {
					this.method_7621(new class_1735(inventory, slotIndex, 10 + col * 18, -1 + row * 18));
				}
			}
		}

		// Add player inventory slots (aligned with Iron Barrel)
		for (int row = 0; row < 3; row++) {
			for (int col = 0; col < 9; col++) {
				// Move inventory down by 3 slots (54px): 121 -> 175
				this.method_7621(new class_1735(playerInventory, col + row * 9 + 9, 10 + col * 18, 165 + row * 18));
			}
		}

		// Add player hotbar slots (aligned with Iron Barrel)
		for (int col = 0; col < 9; col++) {
			// Move hotbar down by 3 slots (54px): 179 -> 233
			this.method_7621(new class_1735(playerInventory, col, 10 + col * 18, 223));
		}
	}

	@Override
	public class_1799 method_7601(class_1657 player, int index) {
		class_1799 newStack = class_1799.field_8037;
		class_1735 slot = this.field_7761.get(index);
		
		if (slot.method_7681()) {
			class_1799 originalStack = slot.method_7677();
			newStack = originalStack.method_7972();
			
			if (index < BARREL_SIZE) {
				// Moving from barrel to player inventory
				if (!this.method_7616(originalStack, BARREL_SIZE, this.field_7761.size(), true)) {
					return class_1799.field_8037;
				}
			} else {
				// Moving from player inventory to barrel
				if (!this.method_7616(originalStack, 0, BARREL_SIZE, false)) {
					return class_1799.field_8037;
				}
			}
			
			if (originalStack.method_7960()) {
				slot.method_53512(class_1799.field_8037);
			} else {
				slot.method_7668();
			}
		}
		
		return newStack;
	}

	@Override
	public boolean method_7597(class_1657 player) {
		return this.inventory.method_5443(player);
	}

	@Override
	public void method_7595(class_1657 player) {
		super.method_7595(player);
		this.inventory.method_5432(player);
	}
}
