/*
 * Decompiled with CFR 0.152.
 */
package fluffymoment.ironbarrels;

import fluffymoment.ironbarrels.block.DiamondBarrelBlock;
import fluffymoment.ironbarrels.block.GoldBarrelBlock;
import fluffymoment.ironbarrels.block.IronBarrelBlock;
import fluffymoment.ironbarrels.block.NetheriteBarrelBlock;
import fluffymoment.ironbarrels.block.ObsidianBarrelBlock;
import fluffymoment.ironbarrels.block.entity.DiamondBarrelBlockEntity;
import fluffymoment.ironbarrels.block.entity.GoldBarrelBlockEntity;
import fluffymoment.ironbarrels.block.entity.IronBarrelBlockEntity;
import fluffymoment.ironbarrels.block.entity.NetheriteBarrelBlockEntity;
import fluffymoment.ironbarrels.block.entity.ObsidianBarrelBlockEntity;
import fluffymoment.ironbarrels.init.IronBarrelsBlockEntities;
import fluffymoment.ironbarrels.init.IronBarrelsBlocks;
import fluffymoment.ironbarrels.init.IronBarrelsItems;
import fluffymoment.ironbarrels.init.IronBarrelsMenus;
import fluffymoment.ironbarrels.init.IronBarrelsSounds;
import fluffymoment.ironbarrels.init.IronBarrelsTabs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3708;
import net.minecraft.class_3719;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IronBarrels
implements ModInitializer {
    public static final String MOD_ID = "ironbarrels";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ironbarrels");
    private static final Collection<WorkQueueEntry> workQueue = new ConcurrentLinkedQueue<WorkQueueEntry>();

    public void onInitialize() {
        LOGGER.info("Initializing Iron Barrels mod");
        IronBarrelsSounds.register();
        IronBarrelsBlocks.register();
        IronBarrelsBlockEntities.register();
        IronBarrelsItems.register();
        IronBarrelsTabs.register();
        IronBarrelsMenus.register();
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                --work.ticksRemaining;
                if (work.ticksRemaining <= 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> e.action.run());
            workQueue.removeAll(actions);
        });
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> {
            class_1799 stack = player.method_5998(hand);
            if (stack.method_7960()) {
                return class_1269.field_5811;
            }
            if (!player.method_5715()) {
                return class_1269.field_5811;
            }
            class_2338 pos = hit.method_17777();
            class_2680 state = world.method_8320(pos);
            boolean applies = false;
            Runnable applyUpgrade = null;
            if (stack.method_31574(IronBarrelsItems.WOOD_TO_IRON_BARREL_UPGRADE) && state.method_27852(class_2246.field_16328)) {
                applies = true;
                applyUpgrade = () -> {
                    class_2586 oldBe = world.method_8321(pos);
                    if (!(oldBe instanceof class_3719)) {
                        return;
                    }
                    class_3719 oldBarrel = (class_3719)oldBe;
                    int oldSize = oldBarrel.method_5439();
                    class_1799[] carried = new class_1799[oldSize];
                    for (int i = 0; i < oldSize; ++i) {
                        class_1799 s = oldBarrel.method_5438(i);
                        carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
                        oldBarrel.method_5447(i, class_1799.field_8037);
                    }
                    class_2350 facing = (class_2350)state.method_11654((class_2769)class_3708.field_16320);
                    class_2680 newState = (class_2680)IronBarrelsBlocks.IRON_BARREL.method_9564().method_11657((class_2769)IronBarrelBlock.FACING, (Comparable)facing);
                    world.method_8652(pos, newState, 3);
                    class_2586 newBe = world.method_8321(pos);
                    if (newBe instanceof IronBarrelBlockEntity) {
                        IronBarrelBlockEntity ironBe = (IronBarrelBlockEntity)newBe;
                        int newSize = ironBe.method_5439();
                        int limit = Math.min(oldSize, newSize);
                        for (int i = 0; i < limit; ++i) {
                            ironBe.method_5447(i, carried[i].method_7972());
                        }
                        ironBe.method_5431();
                    }
                };
            }
            if (stack.method_31574(IronBarrelsItems.IRON_TO_GOLD_BARREL_UPGRADE) && state.method_27852(IronBarrelsBlocks.IRON_BARREL)) {
                applies = true;
                applyUpgrade = () -> {
                    class_2586 oldBe = world.method_8321(pos);
                    if (!(oldBe instanceof IronBarrelBlockEntity)) {
                        return;
                    }
                    IronBarrelBlockEntity oldBarrel = (IronBarrelBlockEntity)oldBe;
                    int oldSize = oldBarrel.method_5439();
                    class_1799[] carried = new class_1799[oldSize];
                    for (int i = 0; i < oldSize; ++i) {
                        class_1799 s = oldBarrel.method_5438(i);
                        carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
                        oldBarrel.method_5447(i, class_1799.field_8037);
                    }
                    class_2350 facing = (class_2350)state.method_11654((class_2769)IronBarrelBlock.FACING);
                    class_2680 newState = (class_2680)IronBarrelsBlocks.GOLD_BARREL.method_9564().method_11657((class_2769)GoldBarrelBlock.FACING, (Comparable)facing);
                    world.method_8652(pos, newState, 3);
                    class_2586 newBe = world.method_8321(pos);
                    if (newBe instanceof GoldBarrelBlockEntity) {
                        GoldBarrelBlockEntity goldBe = (GoldBarrelBlockEntity)newBe;
                        int newSize = goldBe.method_5439();
                        int limit = Math.min(oldSize, newSize);
                        for (int i = 0; i < limit; ++i) {
                            goldBe.method_5447(i, carried[i].method_7972());
                        }
                        goldBe.method_5431();
                    }
                };
            }
            if (stack.method_31574(IronBarrelsItems.GOLD_TO_DIAMOND_BARREL_UPGRADE) && state.method_27852(IronBarrelsBlocks.GOLD_BARREL)) {
                applies = true;
                applyUpgrade = () -> {
                    class_2586 oldBe = world.method_8321(pos);
                    if (!(oldBe instanceof GoldBarrelBlockEntity)) {
                        return;
                    }
                    GoldBarrelBlockEntity oldBarrel = (GoldBarrelBlockEntity)oldBe;
                    int oldSize = oldBarrel.method_5439();
                    class_1799[] carried = new class_1799[oldSize];
                    for (int i = 0; i < oldSize; ++i) {
                        class_1799 s = oldBarrel.method_5438(i);
                        carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
                        oldBarrel.method_5447(i, class_1799.field_8037);
                    }
                    class_2350 facing = (class_2350)state.method_11654((class_2769)GoldBarrelBlock.FACING);
                    class_2680 newState = (class_2680)IronBarrelsBlocks.DIAMOND_BARREL.method_9564().method_11657((class_2769)DiamondBarrelBlock.FACING, (Comparable)facing);
                    world.method_8652(pos, newState, 3);
                    class_2586 newBe = world.method_8321(pos);
                    if (newBe instanceof DiamondBarrelBlockEntity) {
                        DiamondBarrelBlockEntity diamondBe = (DiamondBarrelBlockEntity)newBe;
                        int newSize = diamondBe.method_5439();
                        int limit = Math.min(oldSize, newSize);
                        for (int i = 0; i < limit; ++i) {
                            diamondBe.method_5447(i, carried[i].method_7972());
                        }
                        diamondBe.method_5431();
                    }
                };
            }
            if (stack.method_31574(IronBarrelsItems.DIAMOND_TO_OBSIDIAN_BARREL_UPGRADE) && state.method_27852(IronBarrelsBlocks.DIAMOND_BARREL)) {
                applies = true;
                applyUpgrade = () -> {
                    class_2586 oldBe = world.method_8321(pos);
                    if (!(oldBe instanceof DiamondBarrelBlockEntity)) {
                        return;
                    }
                    DiamondBarrelBlockEntity oldBarrel = (DiamondBarrelBlockEntity)oldBe;
                    int oldSize = oldBarrel.method_5439();
                    class_1799[] carried = new class_1799[oldSize];
                    for (int i = 0; i < oldSize; ++i) {
                        class_1799 s = oldBarrel.method_5438(i);
                        carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
                        oldBarrel.method_5447(i, class_1799.field_8037);
                    }
                    class_2350 facing = (class_2350)state.method_11654((class_2769)DiamondBarrelBlock.FACING);
                    class_2680 newState = (class_2680)IronBarrelsBlocks.OBSIDIAN_BARREL.method_9564().method_11657((class_2769)ObsidianBarrelBlock.FACING, (Comparable)facing);
                    world.method_8652(pos, newState, 3);
                    class_2586 newBe = world.method_8321(pos);
                    if (newBe instanceof ObsidianBarrelBlockEntity) {
                        ObsidianBarrelBlockEntity obsBe = (ObsidianBarrelBlockEntity)newBe;
                        int newSize = obsBe.method_5439();
                        int limit = Math.min(oldSize, newSize);
                        for (int i = 0; i < limit; ++i) {
                            obsBe.method_5447(i, carried[i].method_7972());
                        }
                        obsBe.method_5431();
                    }
                };
            }
            if (stack.method_31574(IronBarrelsItems.OBSIDIAN_TO_NETHERITE_BARREL_UPGRADE) && state.method_27852(IronBarrelsBlocks.OBSIDIAN_BARREL)) {
                applies = true;
                applyUpgrade = () -> {
                    class_2586 oldBe = world.method_8321(pos);
                    if (!(oldBe instanceof ObsidianBarrelBlockEntity)) {
                        return;
                    }
                    ObsidianBarrelBlockEntity oldBarrel = (ObsidianBarrelBlockEntity)oldBe;
                    int oldSize = oldBarrel.method_5439();
                    class_1799[] carried = new class_1799[oldSize];
                    for (int i = 0; i < oldSize; ++i) {
                        class_1799 s = oldBarrel.method_5438(i);
                        carried[i] = s.method_7960() ? class_1799.field_8037 : s.method_7972();
                        oldBarrel.method_5447(i, class_1799.field_8037);
                    }
                    class_2350 facing = (class_2350)state.method_11654((class_2769)ObsidianBarrelBlock.FACING);
                    class_2680 newState = (class_2680)IronBarrelsBlocks.NETHERITE_BARREL.method_9564().method_11657((class_2769)NetheriteBarrelBlock.FACING, (Comparable)facing);
                    world.method_8652(pos, newState, 3);
                    class_2586 newBe = world.method_8321(pos);
                    if (newBe instanceof NetheriteBarrelBlockEntity) {
                        NetheriteBarrelBlockEntity netheriteBe = (NetheriteBarrelBlockEntity)newBe;
                        int newSize = netheriteBe.method_5439();
                        int limit = Math.min(oldSize, newSize);
                        for (int i = 0; i < limit; ++i) {
                            netheriteBe.method_5447(i, carried[i].method_7972());
                        }
                        netheriteBe.method_5431();
                    }
                };
            }
            if (!applies) {
                return class_1269.field_5811;
            }
            if (world.method_8608()) {
                return class_1269.field_5812;
            }
            applyUpgrade.run();
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            world.method_8396(null, pos, class_3417.field_14559, class_3419.field_15245, 0.4f, 1.2f);
            return class_1269.field_5812;
        });
        LOGGER.info("Iron Barrels mod initialized successfully");
    }

    public static void queueServerWork(int tick, Runnable action) {
        workQueue.add(new WorkQueueEntry(action, tick));
    }

    private static class WorkQueueEntry {
        public final Runnable action;
        public int ticksRemaining;

        public WorkQueueEntry(Runnable action, int ticksRemaining) {
            this.action = action;
            this.ticksRemaining = ticksRemaining;
        }
    }
}

