/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.IOException;
import net.strokkur.packetbooks.commands.PacketBooksCommandBrigadier;
import net.strokkur.packetbooks.config.PacketBooksConfig;
import net.strokkur.packetbooks.config.PacketBooksConfigImpl;
import net.strokkur.packetbooks.config.PluginMode;
import net.strokkur.packetbooks.data.AbstractBookDataHolder;
import net.strokkur.packetbooks.data.FileBookDataHolder;
import net.strokkur.packetbooks.listeners.AbstractModeListener;
import net.strokkur.packetbooks.listeners.StandardModeListener;
import net.strokkur.packetbooks.listeners.UndoModeListener;
import org.bukkit.NamespacedKey;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public final class PacketBooks
extends JavaPlugin
implements Listener {
    private final AbstractBookDataHolder holder = new FileBookDataHolder(this);
    private final NamespacedKey bookIdKey = new NamespacedKey((Plugin)this, "book_id");
    private final PacketBooksConfig config = new PacketBooksConfigImpl();
    @Nullable
    private AbstractModeListener modeListener = null;
    private boolean hasSendDefaultFallback = false;

    public void onLoad() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> PacketBooksCommandBrigadier.register((Commands)event.registrar())));
    }

    public void onEnable() {
        this.holder.loadCurrentId();
        try {
            this.reloadPlugin();
        }
        catch (IOException e) {
            this.getSLF4JLogger().error("A fatal exception occurred while trying to enable PacketBooks, it might not work as expected.", (Throwable)e);
        }
    }

    public void reloadPlugin() throws IOException {
        this.hasSendDefaultFallback = false;
        this.config.reload(this);
        if (this.modeListener != null) {
            HandlerList.unregisterAll((Listener)this.modeListener);
        }
        this.modeListener = switch (this.config.mode()) {
            default -> throw new MatchException(null, null);
            case PluginMode.STANDARD -> new StandardModeListener(this);
            case PluginMode.UNDO -> new UndoModeListener(this);
        };
        this.getServer().getPluginManager().registerEvents((Listener)this.modeListener, (Plugin)this);
    }

    public AbstractBookDataHolder getHolder() {
        return this.holder;
    }

    public NamespacedKey getBookIdKey() {
        return this.bookIdKey;
    }

    public boolean hasSendDefaultFallback() {
        return this.hasSendDefaultFallback;
    }

    public void setHasSendDefaultFallback(boolean hasSendDefaultFallback) {
        this.hasSendDefaultFallback = hasSendDefaultFallback;
    }
}

