/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks.data;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.time.Duration;
import net.strokkur.packetbooks.data.BookData;
import org.jspecify.annotations.Nullable;

public abstract class AbstractBookDataHolder {
    private final Cache<Integer, BookData> cache = Caffeine.newBuilder().expireAfter(Expiry.accessing((key, value) -> Duration.ofMinutes(10L))).build();
    protected int currentId = 0;

    protected abstract @Nullable BookData loadBookData(int var1);

    protected abstract void saveBookData(int var1, BookData var2);

    public abstract void loadCurrentId();

    protected abstract void incrementCurrentId();

    public @Nullable BookData getBookData(int id) {
        return (BookData)this.cache.get((Object)id, this::loadBookData);
    }

    public void updateBookData(int id, BookData bookData) {
        this.cache.put((Object)id, (Object)bookData);
        this.saveBookData(id, bookData);
    }

    public int saveNewBookData(BookData bookData) {
        int id = this.currentId;
        this.cache.put((Object)this.currentId, (Object)bookData);
        this.saveBookData(this.currentId, bookData);
        this.incrementCurrentId();
        return id;
    }
}

