/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks;

import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.io.IOException;
import net.strokkur.packetbooks.commands.PacketBooksCommandBrigadier;
import net.strokkur.packetbooks.config.PacketBooksConfig;
import net.strokkur.packetbooks.config.PacketBooksConfigImpl;
import net.strokkur.packetbooks.config.PluginMode;
import net.strokkur.packetbooks.data.AbstractBookDataHolder;
import net.strokkur.packetbooks.data.FileBookDataHolder;
import net.strokkur.packetbooks.listeners.AbstractModeListener;
import net.strokkur.packetbooks.listeners.DisableModeListener;
import net.strokkur.packetbooks.listeners.StandardModeListener;
import net.strokkur.packetbooks.listeners.UndoModeListener;
import org.bukkit.NamespacedKey;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public final class PacketBooks
extends JavaPlugin
implements Listener {
    private final AbstractBookDataHolder holder = new FileBookDataHolder(this);
    private final NamespacedKey bookIdKey = new NamespacedKey((Plugin)this, "book_id");
    private final PacketBooksConfig config = new PacketBooksConfigImpl();
    @Nullable
    private AbstractModeListener modeListener = null;
    private boolean hasSendDefaultFallback = false;
    private final Object sendDefaultFallbackLock = new Object();

    public void onLoad() {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS.newHandler(event -> PacketBooksCommandBrigadier.register((Commands)event.registrar())));
    }

    public void onEnable() {
        this.holder.loadCurrentId().join();
        try {
            this.reloadPlugin();
        }
        catch (IOException e) {
            this.getSLF4JLogger().error("A fatal exception occurred while trying to enable PacketBooks, it might not work as expected.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPlugin() throws IOException {
        Object object = this.sendDefaultFallbackLock;
        synchronized (object) {
            this.hasSendDefaultFallback = false;
            this.config.reload(this);
        }
        if (this.modeListener != null) {
            HandlerList.unregisterAll((Listener)this.modeListener);
        }
        this.modeListener = switch (this.config.mode()) {
            default -> throw new MatchException(null, null);
            case PluginMode.STANDARD -> new StandardModeListener(this);
            case PluginMode.UNDO -> new UndoModeListener(this);
            case PluginMode.DISABLE -> new DisableModeListener(this);
        };
        this.getServer().getPluginManager().registerEvents((Listener)this.modeListener, (Plugin)this);
    }

    public String getModeName() {
        AbstractModeListener modeListener = this.modeListener;
        if (modeListener == null) {
            return "null";
        }
        return modeListener.getName();
    }

    public AbstractBookDataHolder getHolder() {
        return this.holder;
    }

    public NamespacedKey getBookIdKey() {
        return this.bookIdKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSendDefaultFallback() {
        Object object = this.sendDefaultFallbackLock;
        synchronized (object) {
            return this.hasSendDefaultFallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasSendDefaultFallback(boolean hasSendDefaultFallback) {
        Object object = this.sendDefaultFallbackLock;
        synchronized (object) {
            this.hasSendDefaultFallback = hasSendDefaultFallback;
        }
    }
}

