/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import net.strokkur.packetbooks.config.PacketBooksConfig;
import net.strokkur.packetbooks.config.PacketBooksConfigModel;
import net.strokkur.packetbooks.config.PluginMode;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class PacketBooksConfigImpl
implements PacketBooksConfig {
    private @Nullable PacketBooksConfigModel model = null;

    private static <M> M validateLoaded(@Nullable M model) {
        if (model == null) {
            throw new IllegalStateException("The config file 'config.yml' is not fully loaded.");
        }
        return model;
    }

    private static <M, T> T getNonNull(M model, Function<M, T> function, String name) {
        T result = function.apply(model);
        if (result == null) {
            throw new IllegalStateException("The value for '" + name + "' in the config file 'config.yml' is not declared.");
        }
        return result;
    }

    @Override
    public void reload(JavaPlugin plugin, String filePath) throws IOException {
        Path path = plugin.getDataPath().resolve(filePath);
        if (!Files.exists(path, new LinkOption[0]) && plugin.getResource(filePath) != null) {
            plugin.saveResource(filePath, false);
        }
        if (!Files.exists(path, new LinkOption[0])) {
            this.model = new PacketBooksConfigModel();
            String serialized = PacketBooksConfigModel.serialize(this.model);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)serialized, new OpenOption[0]);
        } else {
            String serialized = Files.readString(path);
            this.model = PacketBooksConfigModel.deserialize(serialized);
        }
        if (this.model == null) {
            throw new IOException("Failed to load configuration model for '" + String.valueOf(path) + "'.");
        }
    }

    @Override
    public PluginMode mode() {
        return PacketBooksConfigImpl.getNonNull(PacketBooksConfigImpl.validateLoaded(this.model), m -> m.parseMode(m.mode), "mode");
    }
}

