/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks.config;

import java.io.Reader;
import java.io.StringReader;
import net.strokkur.packetbooks.PacketBooks;
import net.strokkur.packetbooks.config.PluginMode;
import org.bukkit.configuration.file.YamlConfiguration;

class PacketBooksConfigModel {
    String mode = "STANDARD";

    PacketBooksConfigModel() {
    }

    PluginMode parseMode(String mode) {
        if (mode.equalsIgnoreCase("undo")) {
            return PluginMode.UNDO;
        }
        if (mode.equalsIgnoreCase("disable")) {
            return PluginMode.DISABLE;
        }
        PacketBooks plugin = (PacketBooks)PacketBooks.getPlugin(PacketBooks.class);
        if (!mode.equalsIgnoreCase("standard") && !plugin.hasSendDefaultFallback()) {
            plugin.getSLF4JLogger().warn("({}) The mode has been set to {}, which is not a valid mode. Defaulting to STANDARD.", (Object)"config.yml", (Object)mode);
            plugin.setHasSendDefaultFallback(true);
        }
        return PluginMode.STANDARD;
    }

    static String serialize(PacketBooksConfigModel model) {
        return "mode: " + model.mode;
    }

    static PacketBooksConfigModel deserialize(String serialized) {
        PacketBooksConfigModel out = new PacketBooksConfigModel();
        out.mode = YamlConfiguration.loadConfiguration((Reader)new StringReader(serialized)).getString("mode", out.mode);
        return out;
    }
}

