/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks.data;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.strokkur.packetbooks.data.BookData;
import org.jspecify.annotations.Nullable;

public abstract class AbstractBookDataHolder {
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final AsyncCache<Integer, BookData> cache = Caffeine.newBuilder().expireAfter(Expiry.accessing((key, value) -> Duration.ofMinutes(10L))).buildAsync();
    private volatile int currentId = 0;

    protected void setCurrentIdValue(int value) {
        this.readWriteLock.writeLock().lock();
        try {
            this.currentId = value;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    protected int incrementCurrentIdValue() {
        this.readWriteLock.writeLock().lock();
        try {
            int id = this.currentId;
            this.currentId = ++id;
            int n = id;
            return n;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    protected int getCurrentIdValue() {
        this.readWriteLock.readLock().lock();
        try {
            int n = this.currentId;
            return n;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    protected CompletableFuture<@Nullable BookData> loadBookData(int id) {
        return this.loadBookData(id, this.executorService);
    }

    protected abstract CompletableFuture<@Nullable BookData> loadBookData(int var1, Executor var2);

    protected abstract CompletableFuture<Void> saveBookData(int var1, CompletableFuture<BookData> var2);

    public abstract CompletableFuture<Void> loadCurrentId();

    protected abstract CompletableFuture<Void> incrementCurrentId();

    public CompletableFuture<@Nullable BookData> getBookData(int id) {
        return this.cache.get((Object)id, (i, e) -> this.loadBookData((int)i));
    }

    public void updateBookData(int id, BookData bookData) {
        CompletableFuture<BookData> future = CompletableFuture.completedFuture(bookData);
        this.cache.put((Object)id, future);
        this.saveBookData(id, future);
    }

    public int saveNewBookData(CompletableFuture<BookData> bookData) {
        int id = this.getCurrentIdValue();
        this.cache.put((Object)this.getCurrentIdValue(), bookData);
        this.saveBookData(this.getCurrentIdValue(), bookData);
        this.incrementCurrentId();
        return id;
    }
}

