/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

public record BookData(List<Component> components) {
    public static BookData deserializeFromJson(String json) {
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        JsonArray pagesRaw = JsonParser.parseString((String)json).getAsJsonArray();
        ArrayList<Component> pages = new ArrayList<Component>(pagesRaw.size());
        for (JsonElement jsonElement : pagesRaw) {
            pages.add(serializer.deserializeFromTree(jsonElement));
        }
        return new BookData(pages);
    }

    public static BookData empty() {
        return new BookData(List.of());
    }

    public String serializeToJson() {
        GsonComponentSerializer serializer = GsonComponentSerializer.gson();
        JsonArray pages = new JsonArray(this.components.size());
        for (Component component : this.components) {
            pages.add(serializer.serializeToTree(component));
        }
        return pages.toString();
    }
}

