/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks.data;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.strokkur.packetbooks.data.AbstractBookDataHolder;
import net.strokkur.packetbooks.data.BookData;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FileBookDataHolder
extends AbstractBookDataHolder {
    protected final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final JavaPlugin plugin;
    private final Path currentIdPath;

    public FileBookDataHolder(JavaPlugin plugin) {
        this.plugin = plugin;
        this.currentIdPath = this.plugin.getDataPath().resolve("books/_curr.bin");
    }

    @Override
    protected CompletableFuture<@Nullable BookData> loadBookData(int id, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            String json;
            Path path = this.getPathForId(id);
            if (!Files.exists(path, new LinkOption[0])) {
                return BookData.empty();
            }
            try {
                json = Files.readString(path, StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                this.plugin.getSLF4JLogger().error("Failed to load book data for id {}", (Object)id, (Object)e);
                return null;
            }
            return BookData.deserializeFromJson(json);
        }, executor);
    }

    @Override
    protected CompletableFuture<Void> saveBookData(int id, CompletableFuture<BookData> bookData) {
        return bookData.thenAccept(data -> {
            String json = data.serializeToJson();
            Path path = this.getPathForId(id);
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.writeString(path, (CharSequence)json, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException e) {
                this.plugin.getSLF4JLogger().error("Failed to save book data for id {}", (Object)id, (Object)e);
            }
        });
    }

    @Override
    public CompletableFuture<Void> loadCurrentId() {
        return CompletableFuture.runAsync(() -> {
            if (!Files.exists(this.currentIdPath, new LinkOption[0])) {
                return;
            }
            this.lock.readLock().lock();
            try {
                ByteBuffer buf = ByteBuffer.wrap(Files.readAllBytes(this.currentIdPath));
                super.setCurrentIdValue(buf.getInt());
            }
            catch (IOException e) {
                this.plugin.getSLF4JLogger().error("Failed to load current book id path.", (Throwable)e);
            }
            finally {
                this.lock.readLock().unlock();
            }
        });
    }

    @Override
    protected CompletableFuture<Void> incrementCurrentId() {
        int id = super.incrementCurrentIdValue();
        return CompletableFuture.runAsync(() -> {
            this.lock.writeLock().lock();
            try {
                ByteBuffer buf = ByteBuffer.allocate(4);
                buf.putInt(id);
                Files.write(this.currentIdPath, buf.array(), new OpenOption[0]);
            }
            catch (IOException e) {
                this.plugin.getSLF4JLogger().error("Failed to save current book id path.", (Throwable)e);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        });
    }

    private Path getPathForId(int id) {
        return this.plugin.getDataFolder().toPath().resolve("books/" + id + ".txt");
    }
}

