/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks.listeners;

import com.google.common.base.Preconditions;
import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.WritableBookContent;
import io.papermc.paper.datacomponent.item.WrittenBookContent;
import io.papermc.paper.text.Filtered;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.strokkur.packetbooks.PacketBooks;
import net.strokkur.packetbooks.data.BookData;
import org.bukkit.Material;
import org.bukkit.event.Listener;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jspecify.annotations.Nullable;

public abstract class AbstractModeListener
implements Listener {
    protected final PacketBooks plugin;

    public AbstractModeListener(PacketBooks plugin) {
        this.plugin = plugin;
    }

    public abstract String getName();

    protected void populateInventory(Inventory inventory) {
        for (ItemStack is : inventory.getContents()) {
            this.tryPopulateBookContents(is);
        }
    }

    protected void clearInventory(Inventory inventory) {
        for (ItemStack is : inventory.getContents()) {
            this.tryClearBookContents(is);
        }
    }

    protected boolean isDirectlyAccessibleSlot(int slot) {
        return 0 <= slot && slot < 9 || slot == 40;
    }

    protected void tryPopulateBookContents(@Nullable ItemStack item) {
        if (item != null && (item.getType() == Material.WRITABLE_BOOK || item.getType() == Material.WRITTEN_BOOK)) {
            this.populateBookContents(item);
        }
    }

    protected void tryClearBookContents(@Nullable ItemStack item) {
        if (item != null && (item.getType() == Material.WRITABLE_BOOK || item.getType() == Material.WRITTEN_BOOK)) {
            this.clearBookContents(item);
        }
    }

    protected void clearBookContents(ItemStack book) {
        book.editPersistentDataContainer(pdc -> {
            ArrayList<Component> components = new ArrayList<Component>();
            if (book.hasData((DataComponentType)DataComponentTypes.WRITTEN_BOOK_CONTENT)) {
                content = (WrittenBookContent)book.getData(DataComponentTypes.WRITTEN_BOOK_CONTENT);
                Preconditions.checkNotNull((Object)content);
                for (Filtered componentFiltered : content.pages()) {
                    components.add((Component)componentFiltered.raw());
                }
                WrittenBookContent empty = (WrittenBookContent)WrittenBookContent.writtenBookContent((Filtered)content.title(), (String)content.author()).generation(content.generation()).resolved(content.resolved()).build();
                book.setData(DataComponentTypes.WRITTEN_BOOK_CONTENT, (Object)empty);
            } else if (book.hasData((DataComponentType)DataComponentTypes.WRITABLE_BOOK_CONTENT)) {
                content = (WritableBookContent)book.getData(DataComponentTypes.WRITABLE_BOOK_CONTENT);
                Preconditions.checkNotNull((Object)content);
                for (Filtered componentFiltered : content.pages()) {
                    components.add((Component)PlainTextComponentSerializer.plainText().deserialize((String)componentFiltered.raw()));
                }
                WritableBookContent empty = (WritableBookContent)WritableBookContent.writeableBookContent().build();
                book.setData(DataComponentTypes.WRITABLE_BOOK_CONTENT, (Object)empty);
            }
            if (!pdc.has(this.plugin.getBookIdKey(), PersistentDataType.INTEGER)) {
                int id = this.plugin.getHolder().saveNewBookData(CompletableFuture.completedFuture(new BookData(components)));
                pdc.set(this.plugin.getBookIdKey(), PersistentDataType.INTEGER, (Object)id);
            }
        });
        this.plugin.getSLF4JLogger().debug("[clear] book contents for {}", (Object)book);
    }

    protected void populateBookContents(ItemStack book) {
        Integer id = (Integer)book.getPersistentDataContainer().get(this.plugin.getBookIdKey(), PersistentDataType.INTEGER);
        if (id == null) {
            this.plugin.getSLF4JLogger().debug("[populate] no id set for book {}", (Object)book);
            return;
        }
        BookData data = this.plugin.getHolder().getBookData(id).join();
        if (data == null) {
            this.plugin.getSLF4JLogger().debug("[populate] no data found for book {} with id {}", (Object)book, (Object)id);
            return;
        }
        if (book.hasData((DataComponentType)DataComponentTypes.WRITTEN_BOOK_CONTENT)) {
            WrittenBookContent empty = (WrittenBookContent)book.getData(DataComponentTypes.WRITTEN_BOOK_CONTENT);
            Preconditions.checkNotNull((Object)empty);
            WrittenBookContent original = (WrittenBookContent)WrittenBookContent.writtenBookContent((Filtered)empty.title(), (String)empty.author()).addPages(data.components()).generation(empty.generation()).resolved(empty.resolved()).build();
            book.setData(DataComponentTypes.WRITTEN_BOOK_CONTENT, (Object)original);
        } else if (book.hasData((DataComponentType)DataComponentTypes.WRITABLE_BOOK_CONTENT)) {
            WritableBookContent empty = (WritableBookContent)book.getData(DataComponentTypes.WRITABLE_BOOK_CONTENT);
            Preconditions.checkNotNull((Object)empty);
            List<String> plainText = data.components().stream().map(arg_0 -> ((PlainTextComponentSerializer)PlainTextComponentSerializer.plainText()).serialize(arg_0)).toList();
            WritableBookContent original = (WritableBookContent)WritableBookContent.writeableBookContent().addPages(plainText).build();
            book.setData(DataComponentTypes.WRITABLE_BOOK_CONTENT, (Object)original);
        }
        this.plugin.getSLF4JLogger().debug("[populate] book contents for {}", (Object)book);
    }
}

