/*
 * Decompiled with CFR 0.152.
 */
package net.strokkur.packetbooks.listeners;

import io.papermc.paper.event.player.PlayerInventorySlotChangeEvent;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.strokkur.packetbooks.PacketBooks;
import net.strokkur.packetbooks.data.BookData;
import net.strokkur.packetbooks.listeners.AbstractModeListener;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class StandardModeListener
extends AbstractModeListener {
    public StandardModeListener(PacketBooks plugin) {
        super(plugin);
        for (Player player : plugin.getServer().getOnlinePlayers()) {
            if (player.getOpenInventory().getType() == InventoryType.CRAFTING) {
                this.updatePlayer(player);
                continue;
            }
            this.populateInventory((Inventory)player.getInventory());
            this.populateInventory(player.getOpenInventory().getTopInventory());
        }
    }

    @Override
    public String getName() {
        return "enabled";
    }

    private void updatePlayer(Player player) {
        @Nullable ItemStack[] contents = player.getInventory().getContents();
        int contentsLength = contents.length;
        for (int i = 0; i < contentsLength; ++i) {
            ItemStack itemStack = contents[i];
            if (itemStack == null || itemStack.isEmpty()) continue;
            if (this.isDirectlyAccessibleSlot(i)) {
                this.tryPopulateBookContents(itemStack);
                continue;
            }
            this.tryClearBookContents(itemStack);
        }
    }

    @EventHandler
    void onPlayerJoin(PlayerJoinEvent event) {
        this.updatePlayer(event.getPlayer());
    }

    @EventHandler
    void onPlayerQuit(PlayerQuitEvent event) {
        this.clearInventory((Inventory)event.getPlayer().getInventory());
    }

    @EventHandler
    void onPlayerDropItem(PlayerDropItemEvent event) {
        ItemStack is = event.getItemDrop().getItemStack();
        this.tryClearBookContents(is);
        event.getItemDrop().setItemStack(is);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onBookEdit(PlayerEditBookEvent event) {
        BookMeta newBookMeta = event.getNewBookMeta();
        PersistentDataContainer pdc = newBookMeta.getPersistentDataContainer();
        if (!pdc.has(this.plugin.getBookIdKey(), PersistentDataType.INTEGER)) {
            int newId = this.plugin.getHolder().saveNewBookData(CompletableFuture.completedFuture(new BookData(new ArrayList<Component>(newBookMeta.pages()))));
            pdc.set(this.plugin.getBookIdKey(), PersistentDataType.INTEGER, (Object)newId);
        } else {
            int id = Objects.requireNonNull((Integer)pdc.get(this.plugin.getBookIdKey(), PersistentDataType.INTEGER));
            this.plugin.getHolder().updateBookData(id, new BookData(new ArrayList<Component>(newBookMeta.pages())));
        }
        event.setNewBookMeta(newBookMeta);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onCloseInventory(InventoryCloseEvent event) {
        event.getPlayer().getScheduler().execute((Plugin)this.plugin, () -> {
            for (int slot = 0; slot < 9; ++slot) {
                this.tryPopulateBookContents(event.getPlayer().getInventory().getItem(slot));
            }
        }, null, 1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onOpen(InventoryOpenEvent event) {
        event.getPlayer().getScheduler().execute((Plugin)this.plugin, () -> {
            this.clearInventory((Inventory)event.getPlayer().getInventory());
            this.clearInventory(event.getInventory());
        }, null, 1L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    void onBookMoveInPlayerInventory(PlayerInventorySlotChangeEvent event) {
        if (event.getPlayer().getOpenInventory().getTopInventory().getType() != InventoryType.CRAFTING) {
            return;
        }
        event.getPlayer().getScheduler().execute((Plugin)this.plugin, () -> {
            ItemStack item = event.getPlayer().getInventory().getItem(event.getSlot());
            if (this.isDirectlyAccessibleSlot(event.getSlot())) {
                this.tryPopulateBookContents(item);
            } else {
                this.tryClearBookContents(item);
            }
        }, null, 1L);
    }
}

