/*
 * Decompiled with CFR 0.152.
 */
package PolarMods.simplechatfilter.Config;

import PolarMods.simplechatfilter.Simplechatfilter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;

public class ConfigManager {
    private static final Path CONFIG_DIRECTORY = FabricLoader.getInstance().getConfigDir();
    private static final Path CHAT_FILTER_DIRECTORY = CONFIG_DIRECTORY.resolve("simpleChatFilter");
    private static final File CONFIG_FILE = CHAT_FILTER_DIRECTORY.resolve("config.json").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Logger logger;
    private static boolean isChatLocked;
    private static final HashSet<String> bannedWordSet;
    private static HashMap<Integer, ArrayList<String>> punishmentTrack;

    public static boolean getChatLockStatus() {
        return isChatLocked;
    }

    public static boolean changeLockStatus() {
        isChatLocked = !isChatLocked;
        return isChatLocked;
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            JsonObject jsonObject = new JsonObject();
            JsonArray bannedWords = new JsonArray();
            jsonObject.addProperty("isChatLocked", Boolean.valueOf(isChatLocked));
            bannedWordSet.forEach(arg_0 -> ((JsonArray)bannedWords).add(arg_0));
            jsonObject.add("Banned Words", (JsonElement)bannedWords);
            JsonObject spamTracks = new JsonObject();
            punishmentTrack.forEach((key, value) -> {
                JsonArray array = new JsonArray();
                value.forEach(arg_0 -> ((JsonArray)array).add(arg_0));
                spamTracks.add(key.toString(), (JsonElement)array);
            });
            jsonObject.add("Spam Punishment Track", (JsonElement)spamTracks);
            GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
        }
        catch (Exception e) {
            logger.error("Trouble saving values!");
        }
    }

    public static HashSet<String> getBannedWords() {
        return bannedWordSet;
    }

    public static boolean containsPunishment(int number) {
        return punishmentTrack.containsKey(number);
    }

    public static ArrayList<String> getPunishmentCommands(int number) {
        return punishmentTrack.get(number);
    }

    public static boolean loadConfigs() {
        logger = Simplechatfilter.getLogger();
        if (!CHAT_FILTER_DIRECTORY.toFile().exists()) {
            CHAT_FILTER_DIRECTORY.toFile().mkdir();
            ConfigManager.createDefaultConfig();
        }
        try {
            JsonObject jsonFile;
            JsonElement json = JsonParser.parseReader((Reader)new FileReader(CONFIG_FILE));
            if (json instanceof JsonObject) {
                jsonFile = (JsonObject)json;
                bannedWordSet.clear();
                punishmentTrack.clear();
                jsonFile.getAsJsonArray("Banned Words").forEach(jsonelement -> {
                    try {
                        String word = jsonelement.getAsString();
                        bannedWordSet.add(word);
                    }
                    catch (Exception e) {
                        logger.error("Invalid word: {}", (Object)jsonelement.toString());
                    }
                });
                try {
                    isChatLocked = jsonFile.get("isChatLocked").getAsBoolean();
                }
                catch (Exception e) {
                    isChatLocked = false;
                }
            } else {
                throw new IOException("Invalid JSON Format!");
            }
            jsonFile.getAsJsonObject("Spam Punishment Track").entrySet().forEach(entry -> {
                Integer number = -1;
                ArrayList punishmentMapList = new ArrayList();
                try {
                    number = Integer.parseInt((String)entry.getKey());
                    ((JsonElement)entry.getValue()).getAsJsonArray().forEach(element -> punishmentMapList.add(element.getAsString()));
                }
                catch (NumberFormatException e) {
                    logger.error("Invalid number: {}", (Object)e.toString());
                }
                catch (IllegalStateException e) {
                    logger.error("Invalid Command List: {}", (Object)e.toString());
                }
                punishmentTrack.put(number, punishmentMapList);
            });
            return true;
        }
        catch (IOException e) {
            logger.error("Problems loading lang file.", (Throwable)e);
            return false;
        }
    }

    private static void createDefaultConfig() {
        JsonObject jsonObject = new JsonObject();
        JsonArray bannedWords = new JsonArray();
        bannedWords.add("fuck");
        bannedWords.add("bad word");
        jsonObject.addProperty("isChatLocked", Boolean.valueOf(false));
        jsonObject.add("Banned Words", (JsonElement)bannedWords);
        JsonObject spamTrack = new JsonObject();
        JsonArray punishment = new JsonArray();
        punishment.add("kick {player}");
        spamTrack.add("5", (JsonElement)punishment);
        jsonObject.add("Spam Punishment Track", (JsonElement)spamTrack);
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
        }
        catch (Exception e) {
            logger.error("Trouble initializing config file!");
        }
    }

    static {
        isChatLocked = false;
        bannedWordSet = new HashSet();
        punishmentTrack = new HashMap();
    }
}

