/*
 * Decompiled with CFR 0.152.
 */
package PolarMods.simplechatfilter.Config;

import PolarMods.simplechatfilter.Simplechatfilter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.minecraft.class_2168;
import org.slf4j.Logger;

public class LangConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir();
    private static final Path CONFIG_DIR = CONFIG_PATH.resolve("simpleChatFilter");
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("lang");
    private static Logger logger;
    private static MiniMessage miniMessage;
    private static final Gson GSON;
    private static final Map<String, String> langStrings;
    private static final String PLAYER_PLACEHOLDER = "{player}";
    private static final String WARN_PLACEHOLDER = "{warns}";

    public static void load(class_2168 source) {
        block15: {
            block14: {
                logger = Simplechatfilter.getLogger();
                miniMessage = Simplechatfilter.getMiniMessage();
                if (!CONFIG_FILE.toFile().exists()) {
                    CONFIG_FILE.toFile().mkdirs();
                    JsonObject lang = LangConfig.loadLangFiles();
                    try (FileWriter writer = new FileWriter(CONFIG_FILE.resolve("lang.json").toFile());){
                        GSON.toJson((JsonElement)lang, (Appendable)writer);
                        if (source != null) {
                            source.sendMessage(miniMessage.deserialize((Object)"<green>Initialized Lang File"));
                        }
                    }
                    catch (Exception e) {
                        logger.error("Trouble initializing lang file.", (Throwable)e);
                        if (source == null) break block14;
                        source.sendMessage(miniMessage.deserialize((Object)"<red>Could not Initialize Lang File - Attempting to Load Default Lang File"));
                    }
                }
            }
            try {
                JsonElement json = JsonParser.parseReader((Reader)new FileReader(CONFIG_FILE.resolve("lang.json").toFile()));
                if (json instanceof JsonObject) {
                    JsonObject langFile = (JsonObject)json;
                    for (Map.Entry entry : langFile.entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
                        langStrings.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                }
                if (source != null) {
                    source.sendMessage(miniMessage.deserialize((Object)"<green>Loaded Lang File"));
                }
            }
            catch (IOException e) {
                logger.error("Problems loading lang file.", (Throwable)e);
                if (source == null) break block15;
                source.sendMessage(miniMessage.deserialize((Object)"<red>Could not Load Lang File"));
            }
        }
    }

    private static JsonObject loadLangFiles() {
        JsonObject lang = new JsonObject();
        lang.addProperty("simplechat.chat.lock", "<red>The chat has been locked! Only selected players can speak!");
        lang.addProperty("simplechat.chat.unlock", "<green>The chat has been unlocked!");
        lang.addProperty("simplechat.chat.lock.message", "<red>You cannot speak, the chat is locked");
        lang.addProperty("simplechat.chat.clear.broadcast", "<green>The chat has been cleared");
        lang.addProperty("simplechat.chat.spam.warn", "<red>Stop spamming! You currently have {warns} warns");
        lang.addProperty("simplechat.chat.profanity.warn", "<red>Please watch your language!");
        return lang;
    }

    public static Component getLangString(String entry, String playerName, Integer warnNumber) {
        return LangConfig.formatString(langStrings.getOrDefault(entry, entry), playerName, warnNumber);
    }

    private static Component formatString(String langString, String playerName, Integer warnNumber) {
        return miniMessage.deserialize((Object)langString).replaceText(builder -> builder.matchLiteral(WARN_PLACEHOLDER).replacement((ComponentLike)miniMessage.deserialize((Object)String.valueOf(warnNumber))));
    }

    public static String getUnformattedLangString(String langEntry, String playerName, Integer warnNumber) {
        return langStrings.getOrDefault(langEntry, langEntry).replace(WARN_PLACEHOLDER, String.valueOf(warnNumber));
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        langStrings = new HashMap<String, String>();
    }
}

