/*
 * Decompiled with CFR 0.152.
 */
package PolarMods.simplechatfilter;

import PolarMods.simplechatfilter.Command.CommandRegistration;
import PolarMods.simplechatfilter.Config.ConfigManager;
import PolarMods.simplechatfilter.Config.LangConfig;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Simplechatfilter
implements ModInitializer {
    private static final String MOD_ID = "SimpleChatFilter";
    private static final Logger logger = LoggerFactory.getLogger((String)"SimpleChatFilter");
    private static final HashMap<UUID, Long> playerMessageTimes = new HashMap();
    private static final HashMap<UUID, Integer> playerDailyWarns = new HashMap();
    private static final MiniMessage miniMessage = MiniMessage.builder().build();
    private static MinecraftServer server;

    public static Logger getLogger() {
        return logger;
    }

    public static MinecraftServer getServer() {
        return server;
    }

    public static MiniMessage getMiniMessage() {
        return miniMessage;
    }

    public void onInitialize() {
        try {
            CommandRegistration.registerCommands();
            ConfigManager.loadConfigs();
            LangConfig.load(null);
            Simplechatfilter.registerServerStartEvent();
            Simplechatfilter.registerServerStopEvent();
            Simplechatfilter.registerChatEvent();
        }
        catch (Exception e) {
            logger.error("Could not start up SimpleChatFilter. {}", (Object)e.toString());
        }
    }

    private static boolean hasChatBypassPermission(class_3222 player) {
        LuckPerms api = LuckPermsProvider.get();
        User user = api.getPlayerAdapter(class_3222.class).getUser((Object)player);
        return user.getCachedData().getPermissionData().checkPermission("simplechatfilter.bypass").asBoolean();
    }

    private static void registerServerStartEvent() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            server = minecraftServer;
        });
    }

    private static void registerServerStopEvent() {
        ServerLifecycleEvents.SERVER_STOPPING.register(minecraftServer -> ConfigManager.save());
    }

    private static void registerChatEvent() {
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, player, parameters) -> {
            UUID playerUuid = player.method_5667();
            if (playerMessageTimes.containsKey(playerUuid)) {
                Long previousTime = playerMessageTimes.get(playerUuid);
                Long currentTime = message.method_44864().toEpochMilli();
                playerMessageTimes.put(playerUuid, currentTime);
                if (currentTime - previousTime < 2000L) {
                    if (!playerDailyWarns.containsKey(playerUuid)) {
                        playerDailyWarns.put(playerUuid, 0);
                    }
                    int punishmentNumber = playerDailyWarns.get(playerUuid) + 1;
                    playerDailyWarns.put(playerUuid, punishmentNumber);
                    TextComponent playerResponse = (TextComponent)LangConfig.getLangString("simplechat.chat.spam.warn", player.method_5477().getString(), punishmentNumber);
                    if (!playerResponse.content().isEmpty()) {
                        player.sendMessage((Component)playerResponse);
                    }
                    class_2170 manager = player.method_5682().method_3734();
                    class_2168 source = player.method_5682().method_3739();
                    if (ConfigManager.containsPunishment(punishmentNumber)) {
                        ConfigManager.getPunishmentCommands(punishmentNumber).forEach(command -> manager.method_44252(source, command.replace("{player}", player.method_5477().getString())));
                    }
                }
            } else {
                playerMessageTimes.put(playerUuid, message.method_44864().toEpochMilli());
            }
            if (ConfigManager.getChatLockStatus() && !Simplechatfilter.hasChatBypassPermission(player)) {
                TextComponent playerResponse = (TextComponent)LangConfig.getLangString("simplechat.chat.lock", player.method_5477().getString(), null);
                if (!playerResponse.content().isEmpty()) {
                    player.sendMessage((Component)playerResponse);
                }
                return false;
            }
            return true;
        });
    }
}

