/*
 * Decompiled with CFR 0.152.
 */
package name.modid;

import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import name.modid.TrackerStorage;
import name.modid.commands.TrackCommand;
import name.modid.commands.UntrackCommand;
import name.modid.modmenu.TrackerConfig;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

@Environment(value=EnvType.CLIENT)
public class PlayerTrackerClient
implements ClientModInitializer {
    private final class_310 client = class_310.method_1551();
    private final List<class_1657> trackedPlayers = new ArrayList<class_1657>();
    private class_304 switchTargetKey;
    public static class_1657 currentTarget = null;
    public static UUID currentTargetUUID = null;
    public static String currentTargetName = null;
    public static int targetIndex = 0;

    public void onInitializeClient() {
        this.switchTargetKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.player_tracker.cycle_target", class_3675.class_307.field_1668, 86, "key.categories.player_tracker"));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            UntrackCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
            TrackCommand.register((CommandDispatcher<FabricClientCommandSource>)dispatcher);
        });
        TrackerStorage.LoadedTracker loaded = TrackerStorage.load();
        if (loaded != null) {
            currentTargetUUID = loaded.uuid();
            currentTargetName = loaded.name();
        }
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 == null || client.field_1687 == null) {
                return;
            }
            this.trackedPlayers.clear();
            for (class_1657 player : client.field_1687.method_18456()) {
                if (player.method_31481() || Objects.equals(player, client.field_1724)) continue;
                this.trackedPlayers.add(player);
                if (currentTarget != null || currentTargetUUID == null || !player.method_5667().equals(currentTargetUUID)) continue;
                currentTarget = player;
            }
            if (currentTarget == null && currentTargetName != null) {
                for (class_1657 player : this.trackedPlayers) {
                    if (!player.method_5477().getString().equalsIgnoreCase(currentTargetName)) continue;
                    currentTarget = player;
                    currentTargetUUID = player.method_5667();
                    break;
                }
            }
            while (this.switchTargetKey.method_1436()) {
                if (this.trackedPlayers.isEmpty()) {
                    currentTarget = null;
                    currentTargetUUID = null;
                    currentTargetName = null;
                    targetIndex = 0;
                    TrackerStorage.save(null, null);
                    client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"tracker.no_players").method_27692(class_124.field_1061), true);
                    continue;
                }
                targetIndex = (targetIndex + 1) % this.trackedPlayers.size();
                currentTarget = this.trackedPlayers.get(targetIndex);
                currentTargetUUID = currentTarget.method_5667();
                currentTargetName = currentTarget.method_5477().getString();
                TrackerStorage.save(currentTargetUUID, currentTargetName);
                client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"tracker.selected_target", (Object[])new Object[]{currentTargetName}).method_27692(class_124.field_1060), true);
            }
            if (currentTarget != null && !this.trackedPlayers.contains(currentTarget)) {
                currentTarget = null;
                targetIndex = 0;
            }
        });
        HudRenderCallback.EVENT.register((matrices, tickDelta) -> {
            if (this.client.field_1724 == null || this.client.field_1772 == null || class_310.method_1551().field_1690.field_1866) {
                return;
            }
            int y = TrackerConfig.hudY;
            int screenWidth = this.client.method_22683().method_4486();
            if (currentTarget != null) {
                class_243 playerPos = this.client.field_1724.method_19538();
                class_243 targetPos = currentTarget.method_19538();
                int distance = (int)playerPos.method_1022(targetPos);
                String shownDistance = currentTarget.method_5715() ? class_2561.method_43471((String)"tracker.hidden_distance").getString() : Integer.toString(distance);
                class_5250 line1 = class_2561.method_43469((String)"tracker.tracking", (Object[])new Object[]{currentTarget.method_5477().getString()});
                class_5250 line2 = class_2561.method_43469((String)"tracker.distance", (Object[])new Object[]{shownDistance});
                int line1Width = this.client.field_1772.method_27525((class_5348)line1);
                int line2Width = this.client.field_1772.method_27525((class_5348)line2);
                int baseX = TrackerConfig.alignRight ? screenWidth - Math.max(line1Width, line2Width) - TrackerConfig.hudX : TrackerConfig.hudX;
                matrices.method_27535(this.client.field_1772, (class_2561)line1, baseX, y, 0x55FF55);
                matrices.method_27535(this.client.field_1772, (class_2561)line2, baseX, y + 10, 0xFFFFFF);
            } else if (currentTargetUUID != null || currentTargetName != null) {
                String displayName = currentTargetName != null ? currentTargetName : "???";
                class_5250 line1 = class_2561.method_43469((String)"tracker.tracking", (Object[])new Object[]{displayName});
                class_5250 line2 = class_2561.method_43471((String)"tracker.out_of_range");
                int line1Width = this.client.field_1772.method_27525((class_5348)line1);
                int line2Width = this.client.field_1772.method_27525((class_5348)line2);
                int baseX = TrackerConfig.alignRight ? screenWidth - Math.max(line1Width, line2Width) - TrackerConfig.hudX : TrackerConfig.hudX;
                matrices.method_27535(this.client.field_1772, (class_2561)line1, baseX, y, 0x55FF55);
                matrices.method_27535(this.client.field_1772, (class_2561)line2, baseX, y + 10, 0xAAAAAA);
            } else {
                class_5250 line = class_2561.method_43471((String)"tracker.not_found");
                int width = this.client.field_1772.method_27525((class_5348)line);
                int baseX = TrackerConfig.alignRight ? screenWidth - width - TrackerConfig.hudX : TrackerConfig.hudX;
                matrices.method_27535(this.client.field_1772, (class_2561)line, baseX, y, 0xAAAAAA);
            }
        });
    }

    public static void clearTarget() {
        currentTarget = null;
        currentTargetUUID = null;
        currentTargetName = null;
        TrackerStorage.save(null, null);
    }
}

