/*
 * Decompiled with CFR 0.152.
 */
package name.modid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class TrackerStorage {
    private static final Path FILE_PATH = FabricLoader.getInstance().getConfigDir().resolve("player_tracker.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void save(UUID uuid, String name) {
        JsonObject json = new JsonObject();
        if (uuid != null) {
            json.addProperty("trackedUUID", uuid.toString());
        }
        if (name != null && !name.isEmpty()) {
            json.addProperty("trackedName", name);
        }
        try {
            Files.createDirectories(FILE_PATH.getParent(), new FileAttribute[0]);
            Files.write(FILE_PATH, GSON.toJson((JsonElement)json).getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LoadedTracker load() {
        if (!Files.exists(FILE_PATH, new LinkOption[0])) {
            return null;
        }
        try {
            String content = new String(Files.readAllBytes(FILE_PATH));
            JsonObject json = (JsonObject)GSON.fromJson(content, JsonObject.class);
            UUID uuid = json.has("trackedUUID") ? UUID.fromString(json.get("trackedUUID").getAsString()) : null;
            String name = json.has("trackedName") ? json.get("trackedName").getAsString() : null;
            return new LoadedTracker(uuid, name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record LoadedTracker(UUID uuid, String name) {
    }
}

