/*
 * Decompiled with CFR 0.152.
 */
package name.modid.modmenu;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class TrackerConfig {
    public static int hudX = 8;
    public static int hudY = 8;
    public static boolean alignRight = true;
    private static TrackerConfig INSTANCE;
    private static final Gson GSON;
    private static final File CONFIG_FILE;

    public static void setHudX(int x) {
        hudX = x;
    }

    public static void setHudY(int y) {
        hudY = y;
    }

    public static void setAlignRight(boolean value) {
        alignRight = value;
    }

    public static TrackerConfig get() {
        if (INSTANCE == null) {
            TrackerConfig.load();
        }
        return INSTANCE;
    }

    public static void load() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                INSTANCE = (TrackerConfig)GSON.fromJson((Reader)reader, TrackerConfig.class);
                System.out.println("[PlayerTracker] Config Load Successful!");
            }
            catch (IOException e) {
                System.err.println("[PlayerTracker] Config Load failed");
                INSTANCE = new TrackerConfig();
            }
        } else {
            INSTANCE = new TrackerConfig();
            TrackerConfig.save();
        }
    }

    public static void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson((Object)TrackerConfig.get(), (Appendable)writer);
            System.out.println("[PlayerTracker] Config saved Successful!");
        }
        catch (IOException e) {
            System.err.println("[PlayerTracker] Config save failed: " + e.getMessage());
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        CONFIG_FILE = new File(FabricLoader.getInstance().getConfigDir().toFile(), "player_tracker.json");
    }
}

