/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.datagen;

import java.util.Arrays;
import net.alminoris.aestheticshelving.block.ModBlocks;
import net.alminoris.aestheticshelving.util.helper.BlockSetsHelper;
import net.alminoris.aestheticshelving.util.helper.ModJsonHelper;
import net.alminoris.aestheticshelving.util.helper.ModJsonTemplates;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "aestheticshelving", exFileHelper);
    }

    protected void registerStatesAndModels() {
        for (String name : BlockSetsHelper.getWoods()) {
            if (!Arrays.asList(BlockSetsHelper.WOODS).contains(name)) {
                this.registerShelf(ModBlocks.SHELVES.get(name), "aestheticshelving:block/", "shelf_" + name, "stripped_" + name + "_log", name + "_log");
                this.registerStandingShelf(ModBlocks.STANDING_SHELVES.get(name), "aestheticshelving:block/", "standing_shelf_" + name, "stripped_" + name + "_log", name + "_log");
                this.registerCornerShelf(ModBlocks.CORNER_SHELVES.get(name), "aestheticshelving:block/", "corner_shelf_" + name, "stripped_" + name + "_log", name + "_log");
                this.registerTowerShelf(ModBlocks.TOWER_SHELVES.get(name), "aestheticshelving:block/", "tower_shelf_" + name, "stripped_" + name + "_log", name + "_log");
                this.registerLadderShelf(ModBlocks.LADDER_SHELVES.get(name), "aestheticshelving:block/", "ladder_shelf_" + name, "stripped_" + name + "_log", name + "_log");
                this.registerCeilingShelf(ModBlocks.CEILING_SHELVES.get(name), "aestheticshelving:block/", "ceiling_shelf_" + name, "stripped_" + name + "_log");
                continue;
            }
            String logName = name.equals("crimson") || name.equals("warped") ? "stem" : (name.equals("bamboo") ? "block" : "log");
            this.registerShelf(ModBlocks.SHELVES.get(name), "minecraft:block/", "shelf_" + name, "stripped_" + name + "_" + logName, name + "_" + logName);
            this.registerStandingShelf(ModBlocks.STANDING_SHELVES.get(name), "minecraft:block/", "standing_shelf_" + name, "stripped_" + name + "_" + logName, name + "_" + logName);
            this.registerCornerShelf(ModBlocks.CORNER_SHELVES.get(name), "minecraft:block/", "corner_shelf_" + name, "stripped_" + name + "_" + logName, name + "_" + logName);
            this.registerTowerShelf(ModBlocks.TOWER_SHELVES.get(name), "minecraft:block/", "tower_shelf_" + name, "stripped_" + name + "_" + logName, name + "_" + logName);
            this.registerLadderShelf(ModBlocks.LADDER_SHELVES.get(name), "minecraft:block/", "ladder_shelf_" + name, "stripped_" + name + "_" + logName, name + "_" + logName);
            this.registerCeilingShelf(ModBlocks.CEILING_SHELVES.get(name), "minecraft:block/", "ceiling_shelf_" + name, "stripped_" + name + "_" + logName);
        }
    }

    public void registerShelf(DeferredBlock<Block> block, String modId, String name, String baseName, String legName) {
        ModJsonHelper.registerShelfBlockModel(ModJsonTemplates.SHELF, name, modId + baseName, modId + legName, "normal");
        ModJsonHelper.registerShelfBlockModel(ModJsonTemplates.SHELF_CENTER, name, modId + baseName, modId + legName, "center");
        ModJsonHelper.registerShelfBlockModel(ModJsonTemplates.SHELF_LEFT, name, modId + baseName, modId + legName, "left");
        ModJsonHelper.registerShelfBlockModel(ModJsonTemplates.SHELF_RIGHT, name, modId + baseName, modId + legName, "right");
        ModJsonHelper.createBlockstate(ModJsonTemplates.SHELF_BLOCKSTATE, name);
        this.blockItem(block, "block/" + name);
    }

    public void registerStandingShelf(DeferredBlock<Block> block, String modId, String name, String baseName, String legName) {
        ModJsonHelper.registerStandingShelfBlockModel(ModJsonTemplates.STANDING_SHELF, name, modId + baseName, modId + legName);
        ModJsonHelper.createBlockstate(ModJsonTemplates.BLOCKSTATE, name);
        this.blockItem(block, "block/" + name);
    }

    public void registerCornerShelf(DeferredBlock<Block> block, String modId, String name, String baseName, String legName) {
        ModJsonHelper.registerStandingShelfBlockModel(ModJsonTemplates.CORNER_SHELF, name, modId + baseName, modId + legName);
        ModJsonHelper.createBlockstate(ModJsonTemplates.BLOCKSTATE, name);
        this.blockItem(block, "block/" + name);
    }

    public void registerTowerShelf(DeferredBlock<Block> block, String modId, String name, String baseName, String legName) {
        ModJsonHelper.registerStandingShelfBlockModel(ModJsonTemplates.TOWER_SHELF, name, modId + baseName, modId + legName);
        ModJsonHelper.createBlockstate(ModJsonTemplates.BLOCKSTATE, name);
        this.blockItem(block, "block/" + name);
    }

    public void registerLadderShelf(DeferredBlock<Block> block, String modId, String name, String baseName, String legName) {
        ModJsonHelper.registerStandingShelfBlockModel(ModJsonTemplates.LADDER_SHELF, name, modId + baseName, modId + legName);
        ModJsonHelper.createBlockstate(ModJsonTemplates.BLOCKSTATE, name);
        this.blockItem(block, "block/" + name);
    }

    public void registerCeilingShelf(DeferredBlock<Block> block, String modId, String name, String baseName) {
        ModJsonHelper.registerCeilingShelfBlockModel(ModJsonTemplates.CEILING_SHELF, name, modId + baseName);
        ModJsonHelper.createBlockstate(ModJsonTemplates.BLOCKSTATE, name);
        this.blockItem(block, "block/" + name);
    }

    private void blockItem(DeferredBlock<? extends Block> blockRegistryObject, String name) {
        this.simpleBlockItem((Block)blockRegistryObject.get(), (ModelFile)new ModelFile.UncheckedModelFile("aestheticshelving:" + name));
    }
}

