/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.datagen;

import java.util.concurrent.CompletableFuture;
import net.alminoris.aestheticshelving.block.ModBlocks;
import net.alminoris.aestheticshelving.util.helper.BlockSetsHelper;
import net.alminoris.aestheticshelving.util.helper.ModJsonHelper;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected void buildRecipes(@NotNull RecipeOutput recipeExporter) {
        for (String name : BlockSetsHelper.WOODS) {
            String blockName = name.equals("crimson") || name.equals("warped") ? "stem" : (name.equals("bamboo") ? "block" : "log");
            Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)("stripped_" + name + "_" + blockName)));
            Block block1 = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.withDefaultNamespace((String)(name + "_" + blockName)));
            this.registerShelf(recipeExporter, (Block)ModBlocks.SHELVES.get(name).get(), block1, block);
            this.registerStandingShelf(recipeExporter, (Block)ModBlocks.STANDING_SHELVES.get(name).get(), block1, block);
            this.registerCornerShelf(recipeExporter, (Block)ModBlocks.CORNER_SHELVES.get(name).get(), block1, block);
            this.registerTowerShelf(recipeExporter, (Block)ModBlocks.TOWER_SHELVES.get(name).get(), block1, block);
            this.registerLadderShelf(recipeExporter, (Block)ModBlocks.LADDER_SHELVES.get(name).get(), block1, block);
            this.registerCeilingShelf(recipeExporter, (Block)ModBlocks.CEILING_SHELVES.get(name).get(), block);
        }
        for (String name : BlockSetsHelper.EXTRA_WOODS_AN) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "arborealnature:" + name + "_log", "arborealnature:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "arborealnature:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : BlockSetsHelper.EXTRA_WOODS_WF) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "wildfields:" + name + "_log", "wildfields:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "wildfields:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : BlockSetsHelper.WT_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "whisperleaftrees:" + name + "_log", "whisperleaftrees:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "whisperleaftrees:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : BlockSetsHelper.ST_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "silverwoodtrees:" + name + "_log", "silverwoodtrees:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "silverwoodtrees:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : BlockSetsHelper.MT_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "missingtrees:" + name + "_log", "missingtrees:stripped_" + name + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "missingtrees:stripped_" + name + "_log", "\"# #\",", "\"///\"", "");
        }
        for (String name : BlockSetsHelper.NSS_WOOD_NAMES) {
            ModJsonHelper.createShapedRecipe("shelf_" + name, "4", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"#/#\"", "", "");
            ModJsonHelper.createShapedRecipe("standing_shelf_" + name, "4", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"/#\",", "\"/#\"", "");
            ModJsonHelper.createShapedRecipe("corner_shelf_" + name, "4", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"#/\",", "\" #\"", "");
            ModJsonHelper.createShapedRecipe("tower_shelf_" + name, "3", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\" / \",", "\"/#/\",", "\"/#/\"");
            ModJsonHelper.createShapedRecipe("ladder_shelf_" + name, "2", "natures_spirit:" + name.replace("_nss", "") + "_log", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"#/ \",", "\"#/ \",", "\" #/\"");
            ModJsonHelper.createShapedRecipe("ceiling_shelf_" + name, "4", "minecraft:chain", "natures_spirit:stripped_" + name.replace("_nss", "") + "_log", "\"# #\",", "\"///\"", "");
        }
    }

    private void registerShelf(RecipeOutput recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)4).pattern("#/#").define(Character.valueOf('#'), (ItemLike)ing1).define(Character.valueOf('/'), (ItemLike)ing2).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing1), ModRecipeProvider.has((ItemLike)ing1)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing2), ModRecipeProvider.has((ItemLike)ing2)).save(recipeExporter);
    }

    private void registerStandingShelf(RecipeOutput recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)4).pattern("/#").pattern("/#").define(Character.valueOf('#'), (ItemLike)ing1).define(Character.valueOf('/'), (ItemLike)ing2).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing1), ModRecipeProvider.has((ItemLike)ing1)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing2), ModRecipeProvider.has((ItemLike)ing2)).save(recipeExporter);
    }

    private void registerCornerShelf(RecipeOutput recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)4).pattern("#/").pattern(" #").define(Character.valueOf('#'), (ItemLike)ing1).define(Character.valueOf('/'), (ItemLike)ing2).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing1), ModRecipeProvider.has((ItemLike)ing1)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing2), ModRecipeProvider.has((ItemLike)ing2)).save(recipeExporter);
    }

    private void registerTowerShelf(RecipeOutput recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)3).pattern(" / ").pattern("/#/").pattern("/#/").define(Character.valueOf('#'), (ItemLike)ing1).define(Character.valueOf('/'), (ItemLike)ing2).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing1), ModRecipeProvider.has((ItemLike)ing1)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing2), ModRecipeProvider.has((ItemLike)ing2)).save(recipeExporter);
    }

    private void registerLadderShelf(RecipeOutput recipeExporter, Block output, Block ing1, Block ing2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)2).pattern("#/ ").pattern("#/ ").pattern(" #/").define(Character.valueOf('#'), (ItemLike)ing1).define(Character.valueOf('/'), (ItemLike)ing2).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing1), ModRecipeProvider.has((ItemLike)ing1)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing2), ModRecipeProvider.has((ItemLike)ing2)).save(recipeExporter);
    }

    private void registerCeilingShelf(RecipeOutput recipeExporter, Block output, Block ing2) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)output, (int)4).pattern("# #").pattern("///").define(Character.valueOf('#'), (ItemLike)Blocks.CHAIN).define(Character.valueOf('/'), (ItemLike)ing2).unlockedBy(ModRecipeProvider.getHasName((ItemLike)Blocks.CHAIN), ModRecipeProvider.has((ItemLike)Blocks.CHAIN)).unlockedBy(ModRecipeProvider.getHasName((ItemLike)ing2), ModRecipeProvider.has((ItemLike)ing2)).save(recipeExporter);
    }
}

