/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.menu;

import net.alminoris.aestheticshelving.block.entity.LadderShelfBlockEntity;
import net.alminoris.aestheticshelving.menu.ModMenus;
import net.alminoris.aestheticshelving.menu.OneItemSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class LadderShelfMenu
extends AbstractContainerMenu {
    private final LadderShelfBlockEntity blockEntity;
    private final ContainerLevelAccess access;

    public LadderShelfMenu(int containerId, Inventory playerInventory, LadderShelfBlockEntity blockEntity) {
        super((MenuType)ModMenus.LADDER_SHELF_MENU.get(), containerId);
        this.blockEntity = blockEntity;
        this.access = ContainerLevelAccess.create((Level)playerInventory.player.level(), (BlockPos)blockEntity.getBlockPos());
        int l = 0;
        for (int i = 0; i < 4; ++i) {
            int base = 80 + 18 * (4 - (i + 1));
            for (int j = 0; j < i + 2; ++j) {
                this.addSlot(new OneItemSlot((Container)blockEntity, l++, base + 18 * j, 24 + 18 * i));
            }
        }
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    public LadderShelfMenu(int containerId, Inventory playerInventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, playerInventory, (LadderShelfBlockEntity)playerInventory.player.level().getBlockEntity(friendlyByteBuf.readBlockPos()));
    }

    public boolean stillValid(Player player) {
        return this.blockEntity != null && this.blockEntity.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack newStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack original = slot.getItem();
            newStack = original.copy();
            int containerSlots = this.blockEntity.getContainerSize();
            int totalSlots = this.slots.size();
            if (index < containerSlots ? !this.moveItemStackTo(original, containerSlots, totalSlots, true) : !this.moveItemStackTo(original, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (original.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return newStack;
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 100 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 158));
        }
    }
}

