/*
 * Decompiled with CFR 0.152.
 */
package net.alminoris.aestheticshelving.block;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.function.Supplier;
import net.alminoris.aestheticshelving.block.custom.CeilingShelfBlock;
import net.alminoris.aestheticshelving.block.custom.CornerShelfBlock;
import net.alminoris.aestheticshelving.block.custom.LadderShelfBlock;
import net.alminoris.aestheticshelving.block.custom.ShelfBlock;
import net.alminoris.aestheticshelving.block.custom.StandingShelfBlock;
import net.alminoris.aestheticshelving.block.custom.TowerShelfBlock;
import net.alminoris.aestheticshelving.item.ModItems;
import net.alminoris.aestheticshelving.util.helper.BlockSetsHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"aestheticshelving");
    public static final Dictionary<String, RegistryObject<Block>> SHELVES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("shelf_" + name, () -> new ShelfBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> STANDING_SHELVES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("standing_shelf_" + name, () -> new StandingShelfBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> CEILING_SHELVES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("ceiling_shelf_" + name, () -> new CeilingShelfBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> CORNER_SHELVES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("corner_shelf_" + name, () -> new CornerShelfBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> LADDER_SHELVES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("ladder_shelf_" + name, () -> new LadderShelfBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };
    public static final Dictionary<String, RegistryObject<Block>> TOWER_SHELVES = new Hashtable<String, RegistryObject<Block>>(){
        {
            for (String name : BlockSetsHelper.getWoods()) {
                this.put(name, ModBlocks.registerBlock("tower_shelf_" + name, () -> new TowerShelfBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS))));
            }
        }
    };

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, RegistryObject<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

